<?php

namespace WPStaging\Pro\Backup\Storage;

abstract class AbstractStorage
{
    protected $identifier;

    protected $label;

    abstract public function authenticate();

    abstract public function testConnection();

    abstract public function revoke();

    abstract public function updateSettings($settings);
    /**
     * Check if the storage is authenticated or not
     *
     * @return boolean true if the storage is authenticated, otherwise returns false
     * @access public
     */
    public function isAuthenticated()
    {
        $options = $this->getOptions();
        if (isset($options['isAuthenticated'])) {
            return $options['isAuthenticated'];
        }
        return false;
    }

    public function getOptions()
    {
        return get_option($this->getOptionName(), []);
    }

    private function getOptionName()
    {
        return 'wpstg_' . $this->identifier;
    }

    /**
     * Save options
     * Save the storage configuration.
     *
     * @param $options
     *
     * @return bool
     * @access public
     */
    public function saveOptions($options = [])
    {
        return update_option($this->getOptionName(), $options, false);
    }

    /**
     * Display storage success message
     *
     * @return void
     */
    public function showAuthenticateSuccessFailureMessage()
    {

        if (empty($_GET['auth-storage'])) {
            return;
        }

        switch ($_GET['auth-storage']) {
            case 'true':
                ?>
                <div class="notice notice-success is-dismissible">
                    <p>
                        <?php printf(__('The %s storage is authenticated successfully!', 'wp-staging'), $this->label); ?>
                    </p>
                </div>
                <?php
                break;
            case 'false':
                ?>
                <div class="wpstg--notice wpstg--error is-dismissible">
                    <p>
                        <?php printf(__('The %s storage authentication failed!', 'wp-staging'), $this->label); ?>
                    </p>
                </div>
                <?php
                break;
        }
    }
}
