<?php
/**
 * Template to My Account manage the customer checks
 *
 *  Override this template by copying it to yourtheme/woocommerce/myaccount/myaccount-paytrace-saved-checks.php
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<h2 id="paytrace-saved-checks" style="margin-top:40px;"><?php _e( 'Saved Checks', WC_PayTrace::TEXT_DOMAIN ); ?></h2>
<table class="shop_table">
	<thead>
	<tr>
		<th><?php _e( 'Routing Number', WC_PayTrace::TEXT_DOMAIN ); ?></th>
		<th><?php _e( 'Account Number', WC_PayTrace::TEXT_DOMAIN ); ?></th>
		<th></th>
	</tr>
	</thead>
	<tbody>
	<?php foreach ( $saved_checks as $n => $check ) : ?>
		<tr>
			<td>... <?php echo $check['tr_last4']; ?></td>
			<td>... <?php echo $check['dda_last4']; ?></td>
			<td>
				<form method="post">
					<input type="hidden" name="paytrace_delete_check" value="<?php echo $n; ?>" />
					<input type="submit" style="float:left;" class="button" value="<?php _e( 'Delete', WC_PayTrace::TEXT_DOMAIN ); ?>" />
					<?php wp_nonce_field( 'paytrace-delete-check', 'paytrace-nonce' ); ?>
				</form>
				<input type="button" class="button paytrace_update_checks_<?php echo $n; ?> alt" name="paytrace_drop_update" value="<?php _e( 'Update', WC_PayTrace::TEXT_DOMAIN ); ?>" />

				<div class="clear"></div>
				<div class="update_check_fields_<?php echo $n; ?>" style="display: none; margin-top: 25px;">
					<form method="post">
						<p>
							<label style="display: block;" for="paytrace_cc_name"><?php _e( 'Name on the Check', WC_PayTrace::TEXT_DOMAIN ); ?>
								<span class="required">*</span></label>
							<input type="text" class="input-text" name="paytrace_check_name">
						</p>

						<p>
							<label style="display: block;" for="paytrace_routing_number"><?php _e( 'Routing Number', WC_PayTrace::TEXT_DOMAIN ); ?>
								<span class="required">*</span></label>
							<input type="text" class="input-text" name="paytrace_routing_number">
						</p>

						<p>
							<label style="display: block;" for="paytrace_account_number"><?php _e( 'Account Number', WC_PayTrace::TEXT_DOMAIN ); ?>
								<span class="required">*</span></label>
							<input type="text" class="input-text" name="paytrace_account_number">
						</p>
						<input type="hidden" name="paytrace_update_check" value="<?php echo $n; ?>" />
						<a class="button paytrace_close_fields_<?php echo $n; ?>"><?php _e( 'Close', WC_PayTrace::TEXT_DOMAIN ); ?></a>
						<input id="place_order" class="button alt" type="submit" value="<?php _e( 'Update', WC_PayTrace::TEXT_DOMAIN ); ?>">
						<?php wp_nonce_field( 'paytrace-update-check', 'paytrace-nonce' ); ?>
						<script type="text/javascript">
							jQuery('.paytrace_update_checks_<?php echo $n; ?>').click(function () {
								jQuery('div.update_check_fields_<?php echo $n; ?>').slideToggle('slow');
							});
							jQuery('.paytrace_close_fields_<?php echo $n; ?>').click(function () {
								jQuery('div.update_check_fields_<?php echo $n; ?>').slideToggle('slow');
							});
						</script>
					</form>
				</div>
			</td>
		</tr>
	<?php endforeach; ?>

	</tbody>
</table>