<?php
/**
 * Template to My Account manage the customer saved cards
 *
 * Override this template by copying it to yourtheme/woocommerce/myaccount/myaccount-paytrace-saved-cards.php
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<h2 id="paytrace-saved-cards" style="margin-top:40px;"><?php _e( 'Saved Cards', WC_PayTrace::TEXT_DOMAIN ); ?></h2>
<table class="shop_table">
	<thead>
	<tr>
		<th><?php _e( 'Card ending in...', WC_PayTrace::TEXT_DOMAIN ); ?></th>
		<th><?php _e( 'Expires', WC_PayTrace::TEXT_DOMAIN ); ?></th>
		<th></th>
	</tr>
	</thead>
	<tbody>
	<?php foreach ( $saved_cards as $n => $card ) : ?>
		<tr>
			<td><?php echo $card['last4']; ?></td>
			<td><?php echo $card['exp_month'] . '/' . $card['exp_year'] ?></td>
			<td>
				<form method="post">
					<input type="hidden" name="paytrace_delete_card" value="<?php echo $n; ?>" />
					<input type="submit" style="float:left;" class="button" value="<?php _e( 'Delete', WC_PayTrace::TEXT_DOMAIN ); ?>" />
					<?php wp_nonce_field( 'paytrace-delete-card', 'paytrace-nonce' ); ?>
				</form>
				<input type="button" class="button paytrace_update_cards_<?php echo $n; ?> alt" name="paytrace_drop_update" value="<?php _e( 'Update', WC_PayTrace::TEXT_DOMAIN ); ?>" />

				<div class="clear"></div>
				<div class="update_card_fields_<?php echo $n; ?>" style="display: none; margin-top: 25px;">
					<form method="post">
						<p>
							<label style="display: block;" for="paytrace_cc_name"><?php _e( 'Name on the Card', WC_PayTrace::TEXT_DOMAIN ); ?>
								<span class="required">*</span></label>
							<input type="text" class="input-text" name="paytrace_cc_name">
						</p>

						<p>
							<label style="display: block;" for="paytrace_cc_number"><?php _e( 'Credit Card Number', WC_PayTrace::TEXT_DOMAIN ); ?>
								<span class="required">*</span></label>
							<input type="text" class="input-text" name="paytrace_cc_number">
						</p>

						<p>
							<label style="display: block;" for="paytrace_cc_type"><?php _e( 'Card Type', WC_PayTrace::TEXT_DOMAIN ); ?>
								<span class="required">*</span></label>
							<select id="paytrace_cc_type" name="paytrace_cc_type">
								<?php
								foreach ( $available_cc as $card ) {
									echo '<option value="' . $card . '">' . $card_options[ $card ] . '</option>';
								}
								?>
							</select>
						</p>

						<p>
							<label style="display: block;" for="paytrace_cc_exp_month"><?php _e( 'Expiration Date', WC_PayTrace::TEXT_DOMAIN ); ?>
								<span class="required">*</span></label>
							<select name="paytrace_cc_exp_month" id="cc-expire-month">
								<option value="">Month</option>
								'
								<?php
								for ( $i = 1; $i < 13; $i ++ ) {
									$month = sprintf( '%02d', $i );
									echo '<option value="' . $month . '">' . $month . '</option> ';
								}
								?>
								'</select>
							<select id="cc-expire-year" name="paytrace_cc_exp_year">
								<option value=""><?php _e( 'Year', WC_PayTrace::TEXT_DOMAIN ); ?></option>
								'
								<?php
								$today = getdate();
								for ( $i = $today['year']; $i < $today['year'] + 10; $i ++ ) {
									$exp_year = strftime( '%Y', mktime( 0, 0, 0, 1, 1, $i ) );
									$yr_short = strftime( '%y', mktime( 0, 0, 0, 1, 1, $i ) );
									echo '<option value="' . $yr_short . '">' . $yr_short . '</option> ';
								}
								?>
								'</select>
						</p>
						<input type="hidden" name="paytrace_update_card" value="<?php echo $n; ?>" />
						<a class="button paytrace_close_fields_<?php echo $n; ?>"><?php _e( 'Close', WC_PayTrace::TEXT_DOMAIN ); ?></a>
						<input id="place_order" class="button alt" type="submit" value="<?php _e( 'Update', WC_PayTrace::TEXT_DOMAIN ); ?>">
						<?php wp_nonce_field( 'paytrace-update-card', 'paytrace-nonce' ); ?>
						<script type="text/javascript">
							jQuery('.paytrace_update_cards_<?php echo $n; ?>').click(function () {
								jQuery('div.update_card_fields_<?php echo $n; ?>').slideToggle('slow');
							});
							jQuery('.paytrace_close_fields_<?php echo $n; ?>').click(function () {
								jQuery('div.update_card_fields_<?php echo $n; ?>').slideToggle('slow');
							});
						</script>
					</form>
				</div>
			</td>
		</tr>
	<?php endforeach; ?>

	</tbody>
</table>