<?php
/**
 * Template Displaying PayTrace Saved Checks
 *
 * Override this template by copying it to yourtheme/woocommerce/checkout/paytrace-saved-checks.php
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$checked = 1;
?>
<div id="saved_checks_info" style="display: none;">
	<p class="form-row">
		<span class="paytrace_manage_checks help" style="float:right;">
			<?php echo sprintf( __( '<a href="%s" class="button">Manage Checks</a>.', WC_PayTrace::TEXT_DOMAIN ), WC_Compat_PayTrace::get_myaccount_url() . '#paytrace-saved-checks' ); ?>
		</span>
		<label><?php _e( 'Use Your Saved eChecks', WC_PayTrace::TEXT_DOMAIN ); ?>
			<span class="required">*</span></label>
		<?php foreach ( $saved_checks as $n => $check ) { ?>
			<input
				type="radio"
				id="paytrace_check_<?php echo $n; ?>"
				name="paytrace-used-check"
				style="width:auto;"
				value="<?php echo $n; ?>"
				<?php checked( $checked, 1 ) ?> />
			<label
				style="display:inline;"
				for="paytrace_check_<?php echo $n; ?>"><?php _e( 'Check routing|account ending', WC_PayTrace::TEXT_DOMAIN ); ?>
				<?php echo $check['tr_last4']; ?>|<?php echo $check['dda_last4'] ?>
			</label>
			<br />
			<?php
			$checked = 0;
		} ?>
		<input type="radio" id="new_checks" name="paytrace-used-check" style="width:auto;" value="new" />
		<label style="display:inline;" for="new_checks"><?php _e( 'Use a new check', WC_PayTrace::TEXT_DOMAIN ); ?></label>

	</p>

	<div class="clear"></div>
</div>