<?php
/**
 * PayTrace Payment Form Saved Cards Template
 *
 * Override this template by copying it to yourtheme/woocommerce/checkout/paytrace-saved-cards.php
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$checked = 1;
?>
<div id="saved_card_info">
	<p class="form-row">
		<span class="paytrace_manage_cards help" style="float:right;">
			<?php echo sprintf( __( '<a href="%s" class="button">Manage Cards</a>.', WC_PayTrace::TEXT_DOMAIN ), WC_Compat_PayTrace::get_myaccount_url() . '#paytrace-saved-cards' ); ?>
		</span>
		<label><?php _e( 'Use Your Saved Cards', WC_PayTrace::TEXT_DOMAIN ); ?> <span class="required">*</span></label>
		<?php foreach ( $saved_cards as $n => $card ) { ?>
			<input
				type="radio"
				id="paytrace_card_<?php echo $n; ?>"
				name="paytrace-used-cc"
				style="width:auto;"
				value="<?php echo $n; ?>"
				<?php checked( $checked, 1 ) ?> />
			<label
				style="display:inline;"
				for="paytrace_card_<?php echo $n; ?>"><?php _e( 'Card ending in', WC_PayTrace::TEXT_DOMAIN ); ?>
				<?php echo $card['last4']; ?> (<?php echo $card['exp_month'] . '/' . $card['exp_year'] ?>)
			</label>
			<br />
			<?php
			$checked = 0;
		} ?>
		<input type="radio" id="new_cc" name="paytrace-used-cc" style="width:auto;" value="new" />
		<label style="display:inline;" for="new_cc"><?php _e( 'Use a new credit card', WC_PayTrace::TEXT_DOMAIN ); ?></label>

	</p>

	<div class="clear"></div>
</div>