<?php
/**
 * Paytrace Payment Form Template
 *
 * Override this template by copying it to yourtheme/woocommerce/checkout/paytrace-payment-form.php
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_script( 'wc-credit-card-form' );

$card_types = '';
foreach ( $available_cc as $card ) {
	$card_types .= '<option value="' . $card . '">' . $card_options[ $card ] . '</option>';
}

$exp_month = '<option value="">' . __( 'Month', WC_PayTrace::TEXT_DOMAIN ) . '</option>';
for ( $i = 1; $i < 13; $i ++ ) {
	$month = sprintf( '%02d', $i );
	$exp_month .= '<option value="' . $month . '">' . $month . '</option>';
}

$today    = getdate();
$exp_year = '<option value="">' . __( 'Year', WC_PayTrace::TEXT_DOMAIN ) . '</option>';
for ( $i = $today['year']; $i < $today['year'] + 10; $i ++ ) {
	$yr_short = strftime( '%y', mktime( 0, 0, 0, 1, 1, $i ) );
	$exp_year .= '<option value="' . $yr_short . '">' . $yr_short . '</option>';
}

$fields = array(
	'card-number-field'    => '<p class="form-row form-row-first">
		<label for="' . esc_attr( $gateway ) . '-card-number">' . __( "Card Number", WC_PayTrace::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
		<input id="' . esc_attr( $gateway ) . '-card-number" class="input-text wc-credit-card-form-card-number" type="text" maxlength="20" autocomplete="off" placeholder="•••• •••• •••• ••••" name="' . $gateway . '-card-number" />
	</p>',
	'card-expiry-field'    => '<p class="form-row form-row-first">
		<label for="' . esc_attr( $gateway ) . '-card-expiry">' . __( "Expiry (MM/YY)", WC_PayTrace::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
		<input id="' . esc_attr( $gateway ) . '-card-expiry" class="input-text wc-credit-card-form-card-expiry" type="text" autocomplete="off" placeholder="MM / YY" name="' . esc_attr( $gateway ) . '-card-expiry" />
	</p>',
	'card-cvc-field'       => '<p class="form-row form-row-last">
		<label for="' . esc_attr( $gateway ) . '-card-cvc">' . __( "Card Code", WC_PayTrace::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
		<input id="' . esc_attr( $gateway ) . '-card-cvc" class="input-text wc-credit-card-form-card-cvc" type="text" autocomplete="off" placeholder="CVC" name="' . esc_attr( $gateway ) . '-card-cvc" />
	</p>',
	'save-card-field'      => '<div class="create-account ' . esc_attr( $gateway ) . '-create-account"><p class="form-row form-row-wide">
		<input id="' . esc_attr( $gateway ) . '-save-card" style="width:auto;" checked="checked" class="tc_save_card" value="1" type="checkbox" name="' . esc_attr( $gateway ) . '-save-card" />
		<label for="' . esc_attr( $gateway ) . '-save-card" style="display:inline;">' . $save_card_text . ' <span class="required">*</span></label>
	</p>',
	'card-type-field'      => '<p class="form-row form-row-last">
		<label for="' . esc_attr( $gateway ) . '-card-type">' . __( "Card Type", WC_PayTrace::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
		<select id="' . esc_attr( $gateway ) . '-card-type"  value="1" name="' . esc_attr( $gateway ) . '-card-type" ><br />'
		. $card_types . '</select></p>',
	'card-exp-month-field' => '<p class="form-row form-row-first">
		<label for="' . esc_attr( $gateway ) . '-card-exp-month">' . __( "Expiration Date", WC_PayTrace::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
		<select id="' . esc_attr( $gateway ) . '-card-exp-month"  value="1" name="' . esc_attr( $gateway ) . '-card-exp-month" ><br />'
		. $exp_month . '</select>',
	'card-exp-year-field'  => '
		<select id="' . esc_attr( $gateway ) . '-card-exp-year"  value="1" name="' . esc_attr( $gateway ) . '-card-exp-year" ><br />'
		. $exp_year . '</select></p>'
);
?>
<fieldset id="<?php echo $gateway; ?>-cc-form">
	<?php do_action( 'wc_paytrace_form_before', $gateway ); ?>
	<?php echo $fields['card-number-field']; ?>
	<?php echo $fields['card-type-field']; ?>
	<div class="clear"></div>
	<?php
	// WC 2.0 compatible. Don't want to leave the customer to enter free form text in the expiration date field
	if ( WC_Compat_PayTrace::is_wc_2_1() ) {
		echo $fields['card-expiry-field'];
	} else {
		echo $fields['card-exp-month-field'];
		echo $fields['card-exp-year-field'];
	} ?>
	<?php echo $fields['card-cvc-field']; ?>
	<div class="clear"></div>
	<?php do_action( 'wc_paytrace_form_after', $gateway ); ?>
</fieldset>
<?php // Cards are always saved when processing Subscriptions
if ( $show_save_customer ) {
	echo $fields['save-card-field'];
} ?>
<div class="clear"></div>
<script type="text/javascript">
	jQuery(document).ready(function ($) {
		$('#order_review')
			.on('change', 'input#paytrace_cc_choice', function () {
				if ($('input#paytrace_cc_choice').is(':checked')) {
					$('fieldset#<?php echo $gateway; ?>-checks-form').hide(200);
					$('div#saved_card_info').show(400);
					$('div#saved_checks_info').hide(400);
					$('#order_review input[name=paytrace-used-cc]').change();
				}
			})
			.on('change', 'input#paytrace_check_choice', function () {
				if ($('input#paytrace_check_choice').is(':checked')) {
					$('fieldset#<?php echo $gateway; ?>-cc-form').hide(200);
					$('div#saved_card_info').hide(200);
					$('div#saved_checks_info').show(200);
					$('#order_review input[name=paytrace-used-check]').change();
				}
			})
			.on('change', 'input[name=paytrace-used-check]', function () {
				if ($('input[name=paytrace-used-check]:checked').val() == 'new') {
					$('fieldset#<?php echo $gateway; ?>-checks-form').show(400);
					$('.<?php echo $gateway; ?>-create-account').show(400);
				} else {
					$('fieldset#<?php echo $gateway; ?>-checks-form').hide(200);
					$('.<?php echo $gateway; ?>-create-account').hide(200);
				}
			})
			.on('change', 'input[name=paytrace-used-cc]', function () {
				if ($('input[name=paytrace-used-cc]:checked').val() == 'new') {
					$('fieldset#<?php echo $gateway; ?>-cc-form').show(400);
					$('.<?php echo $gateway; ?>-create-account').show(400);
				} else {
					$('fieldset#<?php echo $gateway; ?>-cc-form').hide(200);
					$('.<?php echo $gateway; ?>-create-account').hide(200);
				}
			});
		$('#order_review input[name=paytrace-used-cc]').change();
	});
</script>