<?php
/**
 * PayTrace Checks Form Template
 *
 * Override this template by copying it to yourtheme/woocommerce/checkout/paytrace-checks-form.php
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$fields = array(
	'check-routing-field' => '<p class="form-row form-row-first">
		<label
			for="' . esc_attr( $gateway ) . '_check_routing_number">'
		. __( "Check Routing Number", WC_PayTrace::TEXT_DOMAIN ) . '
				<span class="required">*</span>
		</label>
		<input
			id="' . esc_attr( $gateway ) . '_check_routing_number"
			class="input-text paytrace_check_routing_number"
			type="text"
			autocomplete="off"
			placeholder="Routing Number"
			name="' . esc_attr( $gateway ) . '_check_routing_number" />
	</p>',
	'check-account-field' => '<p class="form-row form-row-last">
		<label
			for="' . esc_attr( $gateway ) . '_check_routing_number">'
		. __( "Check Account Number", WC_PayTrace::TEXT_DOMAIN ) . '
				<span class="required">*</span>
		</label>
		<input
			id="' . esc_attr( $gateway ) . '_check_account_number"
			class="input-text paytrace_check_account_number"
			type="text"
			autocomplete="off"
			placeholder="Check Account Number"
			name="' . esc_attr( $gateway ) . '_check_account_number" />
	</p>',
);

?>
<div class="clear"></div>
<fieldset id="<?php echo $gateway; ?>-checks-form" style="display: none;">
	<?php echo $fields['check-routing-field']; ?>
	<?php echo $fields['check-account-field']; ?>
	<div class="clear"></div>
</fieldset>