<?php

// Color Sections
$colorSectionLoginPage = array(
	'Login Page Colors' => array(
		'loginBgColor'              => 'Background',
		'loginFormBgColor'          => 'Form Background',
		'loginFormTextColor'        => 'Form Text',
		'loginFormInputBgColor'     => 'Form Input Field Background',
		'loginFormInputTextColor'   => 'Form Input Field Text',
		'loginFormInputFocusColor'  => 'Form Input Field Focus Border',
		'loginButtonBgColor'        => 'Button Background',
		'loginButtonTextColor'      => 'Button Text',
		'loginButtonHoverBgColor'   => 'Button Background Hover',
		'loginButtonHoverTextColor' => 'Button Hover Text',
		'loginFormLinkColor'        => 'Link',
		'loginFormLinkHoverColor'   => 'Link Hover',
	)
);
$colorSectionAdminMenu = array(
	'Admin Menu Colors' => array(
		'adminMenuBgColor'             => 'Background',
		'adminMenuDividerColor'        => 'Menu Divider',
		'adminNoticeColor'             => 'Update Notice Text',
		'adminNoticeBgColor'           => 'Update Notice Background',
		'Full Width Style Menu Colors' => array(
			'adminTopLevelTextColor'             => 'Top Level Text & Icon',
			'adminTopLevelTextHoverColor'        => 'Top Level Text & Icon Hover',
			'adminTopLevelSelectedTextColor'     => 'Top Level Text & Icon Selected',
			'adminFloatingSubmenuBgColor'        => 'Floating Submenu Background',
			'adminFloatingSubmenuTextColor'      => 'Floating Submenu Text',
			'adminFloatingSubmenuTextHoverColor' => 'Floating Submenu Text Hover',
			'adminOpenSubmenuTextColor'          => 'Open Submenu Text',
			'adminOpenSubmenuTextHoverColor'     => 'Open Submenu Text Hover',
			'adminOpenSubmenuTextSelectedColor'  => 'Open Submenu Text Selected',
		),
		'Collapsed Style Menu Colors'  => array(
			'adminTopLevelSelectedFoldedBg'               => 'Top Level Background Selected',
			'adminTopLevelFoldedTextColor'                => 'Top Level Text',
			'adminTopLevelSelectedFoldedTextColor'        => 'Top Level Text Selected',
			'adminTopLevelSelectedFoldedIconColor'        => 'Top Level Icon Selected',
			'adminFoldedFloatingSubmenuTextColor'         => 'Top Level Selected Submenu Text',
			'adminFoldedFloatingSubmenuTextHoverColor'    => 'Top Level Selected Submenu Text Hover',
			'adminFoldedFloatingSubmenuSelectedTextColor' => 'Top Level Selected Submenu Text Selected',
		)
	)
);
$colorSectionAdminBar = array(
	'Admin Bar Colors' => array(
		'adminBarBgColor'               => 'Background',
		'adminBarBgHoverColor'          => 'Background Hover',
		'adminBarTopLevelColor'         => 'Top Level Text & Icon',
		'adminBarTopLevelHoverColor'    => 'Top Level Text & Icon Hover',
		'adminBarSubmenuTextColor'      => 'Submenu Text',
		'adminBarSubmenuTextHoverColor' => 'Submenu Text Hover',
	)
);
$colorSectionAdminFooter = array(
	'Admin Footer Colors' => array(
		'footerBgColor'        => 'Background',
		'footerTextColor'      => 'Text',
		'footerLinkColor'      => 'Link',
		'footerLinkHoverColor' => 'Link Hover',
	)
);
$colorSectionContent = array(
	'Content Colors' => array(
		'contentTextColor'             => 'Text',
		'contentHeadingTextColor'      => 'Heading',
		'contentLinkColor'             => 'Link',
		'contentLinkHoverColor'        => 'Link Hover',
		'contentTableRowBgHoverColor'  => 'Table Row Hover',
		'contentDividerColor'          => 'Divider',
		'Buttons'                      => array(
			'contentPrimaryButtonBgColor'         => 'Primary Button Background',
			'contentPrimaryButtonTextColor'       => 'Primary Button Text',
			'contentPrimaryButtonBgHoverColor'    => 'Primary Button Background Hover',
			'contentPrimaryButtonTextHoverColor'  => 'Primary Button Text Hover',
			'contentStandardButtonBgColor'        => 'Standard Button Background',
			'contentStandardButtonTextColor'      => 'Standard Button Text',
			'contentStandardButtonBgHoverColor'   => 'Standard Button Background Hover',
			'contentStandardButtonTextHoverColor' => 'Standard Button Text Hover',
		),
		'Screen Options and Help Text' => array(
			'contentMetaBgColor'        => 'Background',
			'contentMetaTextColor'      => 'Text',
			'contentMetaBgHoverColor'   => 'Background Hover',
			'contentMetaTextHoverColor' => 'Text Hover',
		),
		'Misc'                         => array(
			'postStateBackground' => 'Post State Background Color',
		)
	)
);
$colorSectionSidebar = array(
	'Sidebar/Sortables Colors' => array(
		'sidebarBgColor'        => 'Background',
		'sidebarTextColor'      => 'Text',
		'sidebarHeadingColor'   => 'Heading',
		'sidebarLinkColor'      => 'Link',
		'sidebarLinkHoverColor' => 'Link Hover',
		'sidebarIconColor'      => 'Icon',
		'sidebarDividerColor'   => 'Divider',
		'Buttons'               => array(
			'sidebarPrimaryButtonBgColor'         => 'Primary Button Background',
			'sidebarPrimaryButtonTextColor'       => 'Primary Button Text',
			'sidebarPrimaryButtonBgHoverColor'    => 'Primary Button Background Hover',
			'sidebarPrimaryButtonTextHoverColor'  => 'Primary Button Text Hover',
			'sidebarStandardButtonBgColor'        => 'Standard Button Background',
			'sidebarStandardButtonTextColor'      => 'Standard Button Text',
			'sidebarStandardButtonBgHoverColor'   => 'Standard Button Background Hover',
			'sidebarStandardButtonTextHoverColor' => 'Standard Button Text Hover',
		)
	)
);

// Color Scheme Colors
$colorDefault = array(
	'loginBgColor'                                => '#444343',
	'loginFormBgColor'                            => '#eeecec',
	'loginFormTextColor'                          => '#777777',
	'loginFormInputBgColor'                       => '#fbfbfb',
	'loginFormInputTextColor'                     => '#333333',
	'loginFormInputFocusColor'                    => '#5b9dd9',
	'loginButtonBgColor'                          => '#2ea2cc',
	'loginButtonTextColor'                        => '#ffffff',
	'loginButtonHoverBgColor'                     => '#ffffff',
	'loginButtonHoverTextColor'                   => '#2ea2cc',
	'loginFormLinkColor'                          => '#eeebeb',
	'loginFormLinkHoverColor'                     => '#ffffff',
	'adminMenuBgColor'                            => '#302d2d',
	'adminMenuDividerColor'                       => '#262323',
	'adminNoticeColor'                            => '#ffffff',
	'adminNoticeBgColor'                          => '#d54e21',
	'adminTopLevelTextColor'                      => '#888888',
	'adminTopLevelTextHoverColor'                 => '#2ea2cc',
	'adminTopLevelSelectedTextColor'              => '#ea5340',
	'adminFloatingSubmenuBgColor'                 => '#2ea2cc',
	'adminFloatingSubmenuTextColor'               => '#ffffff',
	'adminFloatingSubmenuTextHoverColor'          => '#b9ecff',
	'adminOpenSubmenuTextColor'                   => '#bbbbbb',
	'adminOpenSubmenuTextHoverColor'              => '#ffffff',
	'adminOpenSubmenuTextSelectedColor'           => '#ffffff',
	'adminTopLevelSelectedFoldedBg'               => '#ea5340',
	'adminTopLevelFoldedTextColor'                => '#ffffff',
	'adminTopLevelSelectedFoldedTextColor'        => '#ffffff',
	'adminTopLevelSelectedFoldedIconColor'        => '#ffffff',
	'adminFoldedFloatingSubmenuTextColor'         => '#ffffff',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#ffd8d3',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#ffffff',
	'adminBarBgColor'                             => '#444343',
	'adminBarBgHoverColor'                        => '#333333',
	'adminBarTopLevelColor'                       => '#888888',
	'adminBarTopLevelHoverColor'                  => '#2ea2cc',
	'adminBarSubmenuTextColor'                    => '#eeeeee',
	'adminBarSubmenuTextHoverColor'               => '#2ea2cc',
	'footerBgColor'                               => '#444343',
	'footerTextColor'                             => '#999999',
	'footerLinkColor'                             => '#ffffff',
	'footerLinkHoverColor'                        => '#ffffff',
	'contentTextColor'                            => '#555555',
	'contentHeadingTextColor'                     => '#222222',
	'contentLinkColor'                            => '#0074a2',
	'contentLinkHoverColor'                       => '#2ea2cc',
	'contentTableRowBgHoverColor'                 => '#eeecec',
	'contentDividerColor'                         => '#eeecec',
	'contentPrimaryButtonBgColor'                 => '#2ea2cc',
	'contentPrimaryButtonTextColor'               => '#ffffff',
	'contentPrimaryButtonBgHoverColor'            => '#1e8cbe',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#dcd7d7',
	'contentStandardButtonTextColor'              => '#555555',
	'contentStandardButtonBgHoverColor'           => '#7d7878',
	'contentStandardButtonTextHoverColor'         => '#ffffff',
	'contentMetaBgColor'                          => '#eeecec',
	'contentMetaTextColor'                        => '#777777',
	'contentMetaBgHoverColor'                     => '#eeecec',
	'contentMetaTextHoverColor'                   => '#333333',
	'sidebarBgColor'                              => '#eeecec',
	'sidebarTextColor'                            => '#555555',
	'sidebarHeadingColor'                         => '#222222',
	'sidebarLinkColor'                            => '#0074a2',
	'sidebarLinkHoverColor'                       => '#2ea2cc',
	'sidebarIconColor'                            => '#555555',
	'sidebarDividerColor'                         => '#dad8d8',
	'sidebarPrimaryButtonBgColor'                 => '#2ea2cc',
	'sidebarPrimaryButtonTextColor'               => '#ffffff',
	'sidebarPrimaryButtonBgHoverColor'            => '#1e8cbe',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#dcd7d7',
	'sidebarStandardButtonTextColor'              => '#555555',
	'sidebarStandardButtonBgHoverColor'           => '#7d7878',
	'sidebarStandardButtonTextHoverColor'         => '#ffffff',
	'postStateBackground'                         => '#333333',
);
$colorLight = array(
	'loginBgColor'                                => '#ffffff',
	'loginFormBgColor'                            => '#eaeaea',
	'loginFormTextColor'                          => '#777777',
	'loginFormInputBgColor'                       => '#fbfbfb',
	'loginFormInputTextColor'                     => '#333333',
	'loginFormInputFocusColor'                    => '#2ea2cc',
	'loginButtonBgColor'                          => '#2ea2cc',
	'loginButtonTextColor'                        => '#ffffff',
	'loginButtonHoverBgColor'                     => '#ffffff',
	'loginButtonHoverTextColor'                   => '#2ea2cc',
	'loginFormLinkColor'                          => '#999999',
	'loginFormLinkHoverColor'                     => '#2ea2cc',
	'adminMenuBgColor'                            => '#e5e5e5',
	'adminMenuDividerColor'                       => '#cecece',
	'adminNoticeColor'                            => '#ffffff',
	'adminNoticeBgColor'                          => '#d54e21',
	'adminTopLevelTextColor'                      => '#555555',
	'adminTopLevelTextHoverColor'                 => '#222222',
	'adminTopLevelSelectedTextColor'              => '#ea5340',
	'adminFloatingSubmenuBgColor'                 => '#bfbfbf',
	'adminFloatingSubmenuTextColor'               => '#222222',
	'adminFloatingSubmenuTextHoverColor'          => '#666666',
	'adminOpenSubmenuTextColor'                   => '#666666',
	'adminOpenSubmenuTextHoverColor'              => '#222222',
	'adminOpenSubmenuTextSelectedColor'           => '#222222',
	'adminTopLevelSelectedFoldedBg'               => '#bfbfbf',
	'adminTopLevelFoldedTextColor'                => '#222222',
	'adminTopLevelSelectedFoldedTextColor'        => '#222222',
	'adminTopLevelSelectedFoldedIconColor'        => '#222222',
	'adminFoldedFloatingSubmenuTextColor'         => '#222222',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#666666',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#222222',
	'adminBarBgColor'                             => '#d9d9d9',
	'adminBarBgHoverColor'                        => '#bfbfbf',
	'adminBarTopLevelColor'                       => '#555555',
	'adminBarTopLevelHoverColor'                  => '#222222',
	'adminBarSubmenuTextColor'                    => '#222222',
	'adminBarSubmenuTextHoverColor'               => '#666666',
	'footerBgColor'                               => '#d9d9d9',
	'footerTextColor'                             => '#555555',
	'footerLinkColor'                             => '#222222',
	'footerLinkHoverColor'                        => '#555555',
	'contentTextColor'                            => '#555555',
	'contentHeadingTextColor'                     => '#222222',
	'contentLinkColor'                            => '#0074a2',
	'contentLinkHoverColor'                       => '#2ea2cc',
	'contentTableRowBgHoverColor'                 => '#f4f4f4',
	'contentDividerColor'                         => '#f4f4f4',
	'contentPrimaryButtonBgColor'                 => '#2ea2cc',
	'contentPrimaryButtonTextColor'               => '#ffffff',
	'contentPrimaryButtonBgHoverColor'            => '#1e8cbe',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#e5e5e5',
	'contentStandardButtonTextColor'              => '#555555',
	'contentStandardButtonBgHoverColor'           => '#808080',
	'contentStandardButtonTextHoverColor'         => '#ffffff',
	'contentMetaBgColor'                          => '#f4f4f4',
	'contentMetaTextColor'                        => '#777777',
	'contentMetaBgHoverColor'                     => '#f4f4f4',
	'contentMetaTextHoverColor'                   => '#333333',
	'sidebarBgColor'                              => '#f4f4f4',
	'sidebarTextColor'                            => '#555555',
	'sidebarHeadingColor'                         => '#222222',
	'sidebarLinkColor'                            => '#0074a2',
	'sidebarLinkHoverColor'                       => '#2ea2cc',
	'sidebarIconColor'                            => '#555555',
	'sidebarDividerColor'                         => '#e5e5e5',
	'sidebarPrimaryButtonBgColor'                 => '#2ea2cc',
	'sidebarPrimaryButtonTextColor'               => '#ffffff',
	'sidebarPrimaryButtonBgHoverColor'            => '#1e8cbe',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#dbdbdb',
	'sidebarStandardButtonTextColor'              => '#555555',
	'sidebarStandardButtonBgHoverColor'           => '#808080',
	'sidebarStandardButtonTextHoverColor'         => '#ffffff',
	'postStateBackground'                         => '#888888',
);
$colorBlue = array(
	'loginBgColor'                                => '#73c3df',
	'loginFormBgColor'                            => '#ffffff',
	'loginFormTextColor'                          => '#4b5356',
	'loginFormInputBgColor'                       => '#d9edf4',
	'loginFormInputTextColor'                     => '#4b5356',
	'loginFormInputFocusColor'                    => '#2ea2cc',
	'loginButtonBgColor'                          => '#ffc71c',
	'loginButtonTextColor'                        => '#064c65',
	'loginButtonHoverBgColor'                     => '#1e8cbe',
	'loginButtonHoverTextColor'                   => '#ffffff',
	'loginFormLinkColor'                          => '#ffffff',
	'loginFormLinkHoverColor'                     => '#d9edf4',
	'adminMenuBgColor'                            => '#52accc',
	'adminMenuDividerColor'                       => '#4796b3',
	'adminNoticeColor'                            => '#064c65',
	'adminNoticeBgColor'                          => '#ffc71c',
	'adminTopLevelTextColor'                      => '#ffffff',
	'adminTopLevelTextHoverColor'                 => '#064c65',
	'adminTopLevelSelectedTextColor'              => '#064c65',
	'adminFloatingSubmenuBgColor'                 => '#4796b3',
	'adminFloatingSubmenuTextColor'               => '#cbe8f2',
	'adminFloatingSubmenuTextHoverColor'          => '#ffffff',
	'adminOpenSubmenuTextColor'                   => '#cbe8f2',
	'adminOpenSubmenuTextHoverColor'              => '#ffffff',
	'adminOpenSubmenuTextSelectedColor'           => '#ffffff',
	'adminTopLevelSelectedFoldedBg'               => '#064c65',
	'adminTopLevelFoldedTextColor'                => '#ffffff',
	'adminTopLevelSelectedFoldedTextColor'        => '#ffffff',
	'adminTopLevelSelectedFoldedIconColor'        => '#ffffff',
	'adminFoldedFloatingSubmenuTextColor'         => '#cbe8f2',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#ffffff',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#ffffff',
	'adminBarBgColor'                             => '#73c3df',
	'adminBarBgHoverColor'                        => '#4796b3',
	'adminBarTopLevelColor'                       => '#064c65',
	'adminBarTopLevelHoverColor'                  => '#ffffff',
	'adminBarSubmenuTextColor'                    => '#cbe8f2',
	'adminBarSubmenuTextHoverColor'               => '#ffffff',
	'footerBgColor'                               => '#73c3df',
	'footerTextColor'                             => '#064c65',
	'footerLinkColor'                             => '#137598',
	'footerLinkHoverColor'                        => '#064c65',
	'contentTextColor'                            => '#4b5356',
	'contentHeadingTextColor'                     => '#232e32',
	'contentLinkColor'                            => '#0074a2',
	'contentLinkHoverColor'                       => '#2ea2cc',
	'contentTableRowBgHoverColor'                 => '#d9edf4',
	'contentDividerColor'                         => '#d9edf4',
	'contentPrimaryButtonBgColor'                 => '#ffc71c',
	'contentPrimaryButtonTextColor'               => '#064c65',
	'contentPrimaryButtonBgHoverColor'            => '#1e8cbe',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#bfe4f0',
	'contentStandardButtonTextColor'              => '#064c65',
	'contentStandardButtonBgHoverColor'           => '#73c3df',
	'contentStandardButtonTextHoverColor'         => '#064c65',
	'contentMetaBgColor'                          => '#d9edf4',
	'contentMetaTextColor'                        => '#52accc',
	'contentMetaBgHoverColor'                     => '#d9edf4',
	'contentMetaTextHoverColor'                   => '#064c65',
	'sidebarBgColor'                              => '#d9edf4',
	'sidebarTextColor'                            => '#3f555e',
	'sidebarHeadingColor'                         => '#1b2e34',
	'sidebarLinkColor'                            => '#0074a2',
	'sidebarLinkHoverColor'                       => '#2ea2cc',
	'sidebarIconColor'                            => '#3f555e',
	'sidebarDividerColor'                         => '#bed8e1',
	'sidebarPrimaryButtonBgColor'                 => '#ffc71c',
	'sidebarPrimaryButtonTextColor'               => '#064c65',
	'sidebarPrimaryButtonBgHoverColor'            => '#1e8cbe',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#afd8e5',
	'sidebarStandardButtonTextColor'              => '#064c65',
	'sidebarStandardButtonBgHoverColor'           => '#73c3df',
	'sidebarStandardButtonTextHoverColor'         => '#064c65',
	'postStateBackground'                         => '#4796b3',
);
$colorCoffee = array(
	'loginBgColor'                                => '#59524c',
	'loginFormBgColor'                            => '#e8d9cb',
	'loginFormTextColor'                          => '#57504a',
	'loginFormInputBgColor'                       => '#fbfbfb',
	'loginFormInputTextColor'                     => '#57504a',
	'loginFormInputFocusColor'                    => '#c7a589',
	'loginButtonBgColor'                          => '#c7a589',
	'loginButtonTextColor'                        => '#46403c',
	'loginButtonHoverBgColor'                     => '#57514b',
	'loginButtonHoverTextColor'                   => '#ffffff',
	'loginFormLinkColor'                          => '#c9c0b7',
	'loginFormLinkHoverColor'                     => '#ffffff',
	'adminMenuBgColor'                            => '#59524c',
	'adminMenuDividerColor'                       => '#4d4641',
	'adminNoticeColor'                            => '#ffffff',
	'adminNoticeBgColor'                          => '#abb46f',
	'adminTopLevelTextColor'                      => '#ffffff',
	'adminTopLevelTextHoverColor'                 => '#c7a589',
	'adminTopLevelSelectedTextColor'              => '#abb46f',
	'adminFloatingSubmenuBgColor'                 => '#46403c',
	'adminFloatingSubmenuTextColor'               => '#c9c0b7',
	'adminFloatingSubmenuTextHoverColor'          => '#ffffff',
	'adminOpenSubmenuTextColor'                   => '#c9c0b7',
	'adminOpenSubmenuTextHoverColor'              => '#ffffff',
	'adminOpenSubmenuTextSelectedColor'           => '#ffffff',
	'adminTopLevelSelectedFoldedBg'               => '#abb46f',
	'adminTopLevelFoldedTextColor'                => '#ffffff',
	'adminTopLevelSelectedFoldedTextColor'        => '#ffffff',
	'adminTopLevelSelectedFoldedIconColor'        => '#ffffff',
	'adminFoldedFloatingSubmenuTextColor'         => '#eff4d2',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#ffffff',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#ffffff',
	'adminBarBgColor'                             => '#46403c',
	'adminBarBgHoverColor'                        => '#312b27',
	'adminBarTopLevelColor'                       => '#c9c0b7',
	'adminBarTopLevelHoverColor'                  => '#c7a589',
	'adminBarSubmenuTextColor'                    => '#c9c0b7',
	'adminBarSubmenuTextHoverColor'               => '#ffffff',
	'footerBgColor'                               => '#46403c',
	'footerTextColor'                             => '#c7a589',
	'footerLinkColor'                             => '#c7a589',
	'footerLinkHoverColor'                        => '#ffffff',
	'contentTextColor'                            => '#58514b',
	'contentHeadingTextColor'                     => '#46403c',
	'contentLinkColor'                            => '#79871e',
	'contentLinkHoverColor'                       => '#576307',
	'contentTableRowBgHoverColor'                 => '#e3dbd2',
	'contentDividerColor'                         => '#e3dbd2',
	'contentPrimaryButtonBgColor'                 => '#79871e',
	'contentPrimaryButtonTextColor'               => '#ffffff',
	'contentPrimaryButtonBgHoverColor'            => '#576307',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#e3dbd2',
	'contentStandardButtonTextColor'              => '#59524c',
	'contentStandardButtonBgHoverColor'           => '#59524c',
	'contentStandardButtonTextHoverColor'         => '#e3dbd2',
	'contentMetaBgColor'                          => '#e3dbd2',
	'contentMetaTextColor'                        => '#59524c',
	'contentMetaBgHoverColor'                     => '#dad1c8',
	'contentMetaTextHoverColor'                   => '#46403c',
	'sidebarBgColor'                              => '#e3dbd2',
	'sidebarTextColor'                            => '#554f49',
	'sidebarHeadingColor'                         => '#46403c',
	'sidebarLinkColor'                            => '#79871e',
	'sidebarLinkHoverColor'                       => '#576307',
	'sidebarIconColor'                            => '#554f49',
	'sidebarDividerColor'                         => '#d4cac0',
	'sidebarPrimaryButtonBgColor'                 => '#79871e',
	'sidebarPrimaryButtonTextColor'               => '#ffffff',
	'sidebarPrimaryButtonBgHoverColor'            => '#576307',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#dbc3a8',
	'sidebarStandardButtonTextColor'              => '#59524c',
	'sidebarStandardButtonBgHoverColor'           => '#59524c',
	'sidebarStandardButtonTextHoverColor'         => '#ffffff',
	'postStateBackground'                         => '#59524c',
);
$colorEctoplasm = array(
	'loginBgColor'                                => '#523f6d',
	'loginFormBgColor'                            => '#ffffff',
	'loginFormTextColor'                          => '#413256',
	'loginFormInputBgColor'                       => '#ebe7f0',
	'loginFormInputTextColor'                     => '#413256',
	'loginFormInputFocusColor'                    => '#413256',
	'loginButtonBgColor'                          => '#a3b745',
	'loginButtonTextColor'                        => '#ffffff',
	'loginButtonHoverBgColor'                     => '#93a43e',
	'loginButtonHoverTextColor'                   => '#ffffff',
	'loginFormLinkColor'                          => '#ded2ee',
	'loginFormLinkHoverColor'                     => '#ffffff',
	'adminMenuBgColor'                            => '#523f6d',
	'adminMenuDividerColor'                       => '#43345a',
	'adminNoticeColor'                            => '#ffffff',
	'adminNoticeBgColor'                          => '#d46f15',
	'adminTopLevelTextColor'                      => '#ffffff',
	'adminTopLevelTextHoverColor'                 => '#ded2ee',
	'adminTopLevelSelectedTextColor'              => '#a3b745',
	'adminFloatingSubmenuBgColor'                 => '#413256',
	'adminFloatingSubmenuTextColor'               => '#ded2ee',
	'adminFloatingSubmenuTextHoverColor'          => '#ffffff',
	'adminOpenSubmenuTextColor'                   => '#ded2ee',
	'adminOpenSubmenuTextHoverColor'              => '#ffffff',
	'adminOpenSubmenuTextSelectedColor'           => '#ffffff',
	'adminTopLevelSelectedFoldedBg'               => '#a3b745',
	'adminTopLevelFoldedTextColor'                => '#ffffff',
	'adminTopLevelSelectedFoldedTextColor'        => '#413256',
	'adminTopLevelSelectedFoldedIconColor'        => '#ffffff',
	'adminFoldedFloatingSubmenuTextColor'         => '#523f6d',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#413256',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#413256',
	'adminBarBgColor'                             => '#715a90',
	'adminBarBgHoverColor'                        => '#523f6d',
	'adminBarTopLevelColor'                       => '#ded2ee',
	'adminBarTopLevelHoverColor'                  => '#ffffff',
	'adminBarSubmenuTextColor'                    => '#ded2ee',
	'adminBarSubmenuTextHoverColor'               => '#ffffff',
	'footerBgColor'                               => '#715a90',
	'footerTextColor'                             => '#ffffff',
	'footerLinkColor'                             => '#ded2ee',
	'footerLinkHoverColor'                        => '#ffffff',
	'contentTextColor'                            => '#523f6d',
	'contentHeadingTextColor'                     => '#413256',
	'contentLinkColor'                            => '#758917',
	'contentLinkHoverColor'                       => '#647411',
	'contentTableRowBgHoverColor'                 => '#eef2de',
	'contentDividerColor'                         => '#e5ddf0',
	'contentPrimaryButtonBgColor'                 => '#a3b745',
	'contentPrimaryButtonTextColor'               => '#ffffff',
	'contentPrimaryButtonBgHoverColor'            => '#93a43e',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#e5ddf0',
	'contentStandardButtonTextColor'              => '#513e6b',
	'contentStandardButtonBgHoverColor'           => '#b7a7cc',
	'contentStandardButtonTextHoverColor'         => '#ffffff',
	'contentMetaBgColor'                          => '#e5ddf0',
	'contentMetaTextColor'                        => '#523f6d',
	'contentMetaBgHoverColor'                     => '#ddd4e9',
	'contentMetaTextHoverColor'                   => '#413256',
	'sidebarBgColor'                              => '#e5ddf0',
	'sidebarTextColor'                            => '#503d6a',
	'sidebarHeadingColor'                         => '#413256',
	'sidebarLinkColor'                            => '#ba5b07',
	'sidebarLinkHoverColor'                       => '#413256',
	'sidebarIconColor'                            => '#503d6a',
	'sidebarDividerColor'                         => '#d6cae5',
	'sidebarPrimaryButtonBgColor'                 => '#a3b745',
	'sidebarPrimaryButtonTextColor'               => '#ffffff',
	'sidebarPrimaryButtonBgHoverColor'            => '#93a43e',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#cbbedd',
	'sidebarStandardButtonTextColor'              => '#523f6d',
	'sidebarStandardButtonBgHoverColor'           => '#b7a7cc',
	'sidebarStandardButtonTextHoverColor'         => '#ffffff',
	'postStateBackground'                         => '#523f6d',
);
$colorMidnight = array(
	'loginBgColor'                                => '#353a3e',
	'loginFormBgColor'                            => '#ffffff',
	'loginFormTextColor'                          => '#353a3e',
	'loginFormInputBgColor'                       => '#e4e9ee',
	'loginFormInputTextColor'                     => '#353a3e',
	'loginFormInputFocusColor'                    => '#353a3e',
	'loginButtonBgColor'                          => '#e14d43',
	'loginButtonTextColor'                        => '#ffffff',
	'loginButtonHoverBgColor'                     => '#dd382d',
	'loginButtonHoverTextColor'                   => '#ffffff',
	'loginFormLinkColor'                          => '#e4e9ee',
	'loginFormLinkHoverColor'                     => '#ffffff',
	'adminMenuBgColor'                            => '#363b3f',
	'adminMenuDividerColor'                       => '#2d3134',
	'adminNoticeColor'                            => '#ffffff',
	'adminNoticeBgColor'                          => '#69a8bb',
	'adminTopLevelTextColor'                      => '#ffffff',
	'adminTopLevelTextHoverColor'                 => '#cfdce7',
	'adminTopLevelSelectedTextColor'              => '#e14d43',
	'adminFloatingSubmenuBgColor'                 => '#26292c',
	'adminFloatingSubmenuTextColor'               => '#cfdce7',
	'adminFloatingSubmenuTextHoverColor'          => '#ffffff',
	'adminOpenSubmenuTextColor'                   => '#cfdce7',
	'adminOpenSubmenuTextHoverColor'              => '#ffffff',
	'adminOpenSubmenuTextSelectedColor'           => '#ffffff',
	'adminTopLevelSelectedFoldedBg'               => '#e14d43',
	'adminTopLevelFoldedTextColor'                => '#ffffff',
	'adminTopLevelSelectedFoldedTextColor'        => '#ffffff',
	'adminTopLevelSelectedFoldedIconColor'        => '#ffffff',
	'adminFoldedFloatingSubmenuTextColor'         => '#f2e0de',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#ffffff',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#ffffff',
	'adminBarBgColor'                             => '#4a5158',
	'adminBarBgHoverColor'                        => '#26292c',
	'adminBarTopLevelColor'                       => '#ffffff',
	'adminBarTopLevelHoverColor'                  => '#cfdce7',
	'adminBarSubmenuTextColor'                    => '#cfdce7',
	'adminBarSubmenuTextHoverColor'               => '#ffffff',
	'footerBgColor'                               => '#4a5158',
	'footerTextColor'                             => '#ffffff',
	'footerLinkColor'                             => '#cfdce7',
	'footerLinkHoverColor'                        => '#ffffff',
	'contentTextColor'                            => '#363b3f',
	'contentHeadingTextColor'                     => '#26292c',
	'contentLinkColor'                            => '#e14d43',
	'contentLinkHoverColor'                       => '#dd382d',
	'contentTableRowBgHoverColor'                 => '#e7ebee',
	'contentDividerColor'                         => '#e7ebee',
	'contentPrimaryButtonBgColor'                 => '#e14d43',
	'contentPrimaryButtonTextColor'               => '#ffffff',
	'contentPrimaryButtonBgHoverColor'            => '#dd382d',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#e7ebee',
	'contentStandardButtonTextColor'              => '#363b3f',
	'contentStandardButtonBgHoverColor'           => '#c5c9cc',
	'contentStandardButtonTextHoverColor'         => '#26292c',
	'contentMetaBgColor'                          => '#e7ebee',
	'contentMetaTextColor'                        => '#363b3f',
	'contentMetaBgHoverColor'                     => '#c5c9cc',
	'contentMetaTextHoverColor'                   => '#26292c',
	'sidebarBgColor'                              => '#e7ebee',
	'sidebarTextColor'                            => '#363b3f',
	'sidebarHeadingColor'                         => '#26292c',
	'sidebarLinkColor'                            => '#e14d43',
	'sidebarLinkHoverColor'                       => '#dd382d',
	'sidebarIconColor'                            => '#363b3f',
	'sidebarDividerColor'                         => '#d5dadd',
	'sidebarPrimaryButtonBgColor'                 => '#e14d43',
	'sidebarPrimaryButtonTextColor'               => '#ffffff',
	'sidebarPrimaryButtonBgHoverColor'            => '#dd382d',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#c1cbd2',
	'sidebarStandardButtonTextColor'              => '#363b3f',
	'sidebarStandardButtonBgHoverColor'           => '#363b3f',
	'sidebarStandardButtonTextHoverColor'         => '#ffffff',
	'postStateBackground'                         => '#363b3f',
);
$colorOcean = array(
	'loginBgColor'                                => '#c8e1e9',
	'loginFormBgColor'                            => '#6f8a91',
	'loginFormTextColor'                          => '#b8dbba',
	'loginFormInputBgColor'                       => '#ffffff',
	'loginFormInputTextColor'                     => '#6f8a91',
	'loginFormInputFocusColor'                    => '#546a71',
	'loginButtonBgColor'                          => '#9ebaa0',
	'loginButtonTextColor'                        => '#ffffff',
	'loginButtonHoverBgColor'                     => '#89a98b',
	'loginButtonHoverTextColor'                   => '#ffffff',
	'loginFormLinkColor'                          => '#6f8a91',
	'loginFormLinkHoverColor'                     => '#546a71',
	'adminMenuBgColor'                            => '#738e96',
	'adminMenuDividerColor'                       => '#637c83',
	'adminNoticeColor'                            => '#ffffff',
	'adminNoticeBgColor'                          => '#aa9d88',
	'adminTopLevelTextColor'                      => '#ffffff',
	'adminTopLevelTextHoverColor'                 => '#c8e1e9',
	'adminTopLevelSelectedTextColor'              => '#b8dbba',
	'adminFloatingSubmenuBgColor'                 => '#546a71',
	'adminFloatingSubmenuTextColor'               => '#c8e1e9',
	'adminFloatingSubmenuTextHoverColor'          => '#ffffff',
	'adminOpenSubmenuTextColor'                   => '#c8e1e9',
	'adminOpenSubmenuTextHoverColor'              => '#ffffff',
	'adminOpenSubmenuTextSelectedColor'           => '#ffffff',
	'adminTopLevelSelectedFoldedBg'               => '#b8dbba',
	'adminTopLevelFoldedTextColor'                => '#ffffff',
	'adminTopLevelSelectedFoldedTextColor'        => '#546a71',
	'adminTopLevelSelectedFoldedIconColor'        => '#738e96',
	'adminFoldedFloatingSubmenuTextColor'         => '#627c83',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#546a71',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#546a71',
	'adminBarBgColor'                             => '#627c83',
	'adminBarBgHoverColor'                        => '#546a71',
	'adminBarTopLevelColor'                       => '#ffffff',
	'adminBarTopLevelHoverColor'                  => '#b8dbba',
	'adminBarSubmenuTextColor'                    => '#c8e1e9',
	'adminBarSubmenuTextHoverColor'               => '#ffffff',
	'footerBgColor'                               => '#627c83',
	'footerTextColor'                             => '#ffffff',
	'footerLinkColor'                             => '#c8e1e9',
	'footerLinkHoverColor'                        => '#ffffff',
	'contentTextColor'                            => '#546a71',
	'contentHeadingTextColor'                     => '#3b4b51',
	'contentLinkColor'                            => '#668568',
	'contentLinkHoverColor'                       => '#516f53',
	'contentTableRowBgHoverColor'                 => '#e0e7e8',
	'contentDividerColor'                         => '#e0e7e8',
	'contentPrimaryButtonBgColor'                 => '#9ebaa0',
	'contentPrimaryButtonTextColor'               => '#ffffff',
	'contentPrimaryButtonBgHoverColor'            => '#89a98b',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#e0e7e8',
	'contentStandardButtonTextColor'              => '#546a71',
	'contentStandardButtonBgHoverColor'           => '#c4cdce',
	'contentStandardButtonTextHoverColor'         => '#3b4b51',
	'contentMetaBgColor'                          => '#e0e7e8',
	'contentMetaTextColor'                        => '#546a71',
	'contentMetaBgHoverColor'                     => '#c4cdce',
	'contentMetaTextHoverColor'                   => '#3b4b51',
	'sidebarBgColor'                              => '#e0e7e8',
	'sidebarTextColor'                            => '#546a71',
	'sidebarHeadingColor'                         => '#3b4b51',
	'sidebarLinkColor'                            => '#668568',
	'sidebarLinkHoverColor'                       => '#516f53',
	'sidebarIconColor'                            => '#738e96',
	'sidebarDividerColor'                         => '#d0d7d8',
	'sidebarPrimaryButtonBgColor'                 => '#9ebaa0',
	'sidebarPrimaryButtonTextColor'               => '#ffffff',
	'sidebarPrimaryButtonBgHoverColor'            => '#89a98b',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#c4d0d2',
	'sidebarStandardButtonTextColor'              => '#546a71',
	'sidebarStandardButtonBgHoverColor'           => '#6e8890',
	'sidebarStandardButtonTextHoverColor'         => '#ffffff',
	'postStateBackground'                         => '#627c83',
);
$colorSunrise = array(
	'loginBgColor'                                => '#cf4944',
	'loginFormBgColor'                            => '#a52f2a',
	'loginFormTextColor'                          => '#ffffff',
	'loginFormInputBgColor'                       => '#ffffff',
	'loginFormInputTextColor'                     => '#a52f2a',
	'loginFormInputFocusColor'                    => '#ff9838',
	'loginButtonBgColor'                          => '#dd823b',
	'loginButtonTextColor'                        => '#ffffff',
	'loginButtonHoverBgColor'                     => '#d06a1c',
	'loginButtonHoverTextColor'                   => '#ffffff',
	'loginFormLinkColor'                          => '#ecd3d2',
	'loginFormLinkHoverColor'                     => '#ffffff',
	'adminMenuBgColor'                            => '#cf4944',
	'adminMenuDividerColor'                       => '#b8403b',
	'adminNoticeColor'                            => '#cf4944',
	'adminNoticeBgColor'                          => '#f2d012',
	'adminTopLevelTextColor'                      => '#ffffff',
	'adminTopLevelTextHoverColor'                 => '#ecd3d2',
	'adminTopLevelSelectedTextColor'              => '#ff9838',
	'adminFloatingSubmenuBgColor'                 => '#a52f2a',
	'adminFloatingSubmenuTextColor'               => '#ecd3d2',
	'adminFloatingSubmenuTextHoverColor'          => '#ffffff',
	'adminOpenSubmenuTextColor'                   => '#ecd3d2',
	'adminOpenSubmenuTextHoverColor'              => '#ffffff',
	'adminOpenSubmenuTextSelectedColor'           => '#ffffff',
	'adminTopLevelSelectedFoldedBg'               => '#ff9838',
	'adminTopLevelFoldedTextColor'                => '#ffffff',
	'adminTopLevelSelectedFoldedTextColor'        => '#a52f2a',
	'adminTopLevelSelectedFoldedIconColor'        => '#ffffff',
	'adminFoldedFloatingSubmenuTextColor'         => '#f6e7d9',
	'adminFoldedFloatingSubmenuTextHoverColor'    => '#ffffff',
	'adminFoldedFloatingSubmenuSelectedTextColor' => '#ffffff',
	'adminBarBgColor'                             => '#df6762',
	'adminBarBgHoverColor'                        => '#a52f2a',
	'adminBarTopLevelColor'                       => '#ffffff',
	'adminBarTopLevelHoverColor'                  => '#ecd3d2',
	'adminBarSubmenuTextColor'                    => '#ecd3d2',
	'adminBarSubmenuTextHoverColor'               => '#ffffff',
	'footerBgColor'                               => '#df6762',
	'footerTextColor'                             => '#ffffff',
	'footerLinkColor'                             => '#f6e7d9',
	'footerLinkHoverColor'                        => '#ffffff',
	'contentTextColor'                            => '#cf4944',
	'contentHeadingTextColor'                     => '#a52f2a',
	'contentLinkColor'                            => '#dd823b',
	'contentLinkHoverColor'                       => '#d06a1c',
	'contentTableRowBgHoverColor'                 => '#f7eded',
	'contentDividerColor'                         => '#f7eded',
	'contentPrimaryButtonBgColor'                 => '#dd823b',
	'contentPrimaryButtonTextColor'               => '#ffffff',
	'contentPrimaryButtonBgHoverColor'            => '#d06a1c',
	'contentPrimaryButtonTextHoverColor'          => '#ffffff',
	'contentStandardButtonBgColor'                => '#f7eded',
	'contentStandardButtonTextColor'              => '#cf4944',
	'contentStandardButtonBgHoverColor'           => '#cf4944',
	'contentStandardButtonTextHoverColor'         => '#ffffff',
	'contentMetaBgColor'                          => '#f7eded',
	'contentMetaTextColor'                        => '#d07e7a',
	'contentMetaBgHoverColor'                     => '#f7eded',
	'contentMetaTextHoverColor'                   => '#cf4944',
	'sidebarBgColor'                              => '#f7eded',
	'sidebarTextColor'                            => '#c44540',
	'sidebarHeadingColor'                         => '#a52f2a',
	'sidebarLinkColor'                            => '#dd823b',
	'sidebarLinkHoverColor'                       => '#d06a1c',
	'sidebarIconColor'                            => '#c44540',
	'sidebarDividerColor'                         => '#e8dddd',
	'sidebarPrimaryButtonBgColor'                 => '#dd823b',
	'sidebarPrimaryButtonTextColor'               => '#ffffff',
	'sidebarPrimaryButtonBgHoverColor'            => '#d06a1c',
	'sidebarPrimaryButtonTextHoverColor'          => '#ffffff',
	'sidebarStandardButtonBgColor'                => '#c9a4a4',
	'sidebarStandardButtonTextColor'              => '#ffffff',
	'sidebarStandardButtonBgHoverColor'           => '#a52f2a',
	'sidebarStandardButtonTextHoverColor'         => '#ffffff',
	'postStateBackground'                         => '#cf4944',
);

$colorCustom = array(
	'loginBgColor'                                => $slate_pro_settings['colorSchemeCustomColors']['loginBgColor'],
	'loginFormBgColor'                            => $slate_pro_settings['colorSchemeCustomColors']['loginFormBgColor'],
	'loginFormTextColor'                          => $slate_pro_settings['colorSchemeCustomColors']['loginFormTextColor'],
	'loginFormInputBgColor'                       => $slate_pro_settings['colorSchemeCustomColors']['loginFormInputBgColor'],
	'loginFormInputTextColor'                     => $slate_pro_settings['colorSchemeCustomColors']['loginFormInputTextColor'],
	'loginFormInputFocusColor'                    => $slate_pro_settings['colorSchemeCustomColors']['loginFormInputFocusColor'],
	'loginButtonBgColor'                          => $slate_pro_settings['colorSchemeCustomColors']['loginButtonBgColor'],
	'loginButtonTextColor'                        => $slate_pro_settings['colorSchemeCustomColors']['loginButtonTextColor'],
	'loginButtonHoverBgColor'                     => $slate_pro_settings['colorSchemeCustomColors']['loginButtonHoverBgColor'],
	'loginButtonHoverTextColor'                   => $slate_pro_settings['colorSchemeCustomColors']['loginButtonHoverTextColor'],
	'loginFormLinkColor'                          => $slate_pro_settings['colorSchemeCustomColors']['loginFormLinkColor'],
	'loginFormLinkHoverColor'                     => $slate_pro_settings['colorSchemeCustomColors']['loginFormLinkHoverColor'],
	'adminMenuBgColor'                            => $slate_pro_settings['colorSchemeCustomColors']['adminMenuBgColor'],
	'adminMenuDividerColor'                       => $slate_pro_settings['colorSchemeCustomColors']['adminMenuDividerColor'],
	'adminNoticeColor'                            => $slate_pro_settings['colorSchemeCustomColors']['adminNoticeColor'],
	'adminNoticeBgColor'                          => $slate_pro_settings['colorSchemeCustomColors']['adminNoticeBgColor'],
	'adminTopLevelTextColor'                      => $slate_pro_settings['colorSchemeCustomColors']['adminTopLevelTextColor'],
	'adminTopLevelTextHoverColor'                 => $slate_pro_settings['colorSchemeCustomColors']['adminTopLevelTextHoverColor'],
	'adminTopLevelSelectedTextColor'              => $slate_pro_settings['colorSchemeCustomColors']['adminTopLevelSelectedTextColor'],
	'adminFloatingSubmenuBgColor'                 => $slate_pro_settings['colorSchemeCustomColors']['adminFloatingSubmenuBgColor'],
	'adminFloatingSubmenuTextColor'               => $slate_pro_settings['colorSchemeCustomColors']['adminFloatingSubmenuTextColor'],
	'adminFloatingSubmenuTextHoverColor'          => $slate_pro_settings['colorSchemeCustomColors']['adminFloatingSubmenuTextHoverColor'],
	'adminOpenSubmenuTextColor'                   => $slate_pro_settings['colorSchemeCustomColors']['adminOpenSubmenuTextColor'],
	'adminOpenSubmenuTextHoverColor'              => $slate_pro_settings['colorSchemeCustomColors']['adminOpenSubmenuTextHoverColor'],
	'adminOpenSubmenuTextSelectedColor'           => $slate_pro_settings['colorSchemeCustomColors']['adminOpenSubmenuTextSelectedColor'],
	'adminTopLevelSelectedFoldedBg'               => $slate_pro_settings['colorSchemeCustomColors']['adminTopLevelSelectedFoldedBg'],
	'adminTopLevelFoldedTextColor'                => $slate_pro_settings['colorSchemeCustomColors']['adminTopLevelFoldedTextColor'],
	'adminTopLevelSelectedFoldedTextColor'        => $slate_pro_settings['colorSchemeCustomColors']['adminTopLevelSelectedFoldedTextColor'],
	'adminTopLevelSelectedFoldedIconColor'        => $slate_pro_settings['colorSchemeCustomColors']['adminTopLevelSelectedFoldedIconColor'],
	'adminFoldedFloatingSubmenuTextColor'         => $slate_pro_settings['colorSchemeCustomColors']['adminFoldedFloatingSubmenuTextColor'],
	'adminFoldedFloatingSubmenuTextHoverColor'    => $slate_pro_settings['colorSchemeCustomColors']['adminFoldedFloatingSubmenuTextHoverColor'],
	'adminFoldedFloatingSubmenuSelectedTextColor' => $slate_pro_settings['colorSchemeCustomColors']['adminFoldedFloatingSubmenuSelectedTextColor'],
	'adminBarBgColor'                             => $slate_pro_settings['colorSchemeCustomColors']['adminBarBgColor'],
	'adminBarBgHoverColor'                        => $slate_pro_settings['colorSchemeCustomColors']['adminBarBgHoverColor'],
	'adminBarTopLevelColor'                       => $slate_pro_settings['colorSchemeCustomColors']['adminBarTopLevelColor'],
	'adminBarTopLevelHoverColor'                  => $slate_pro_settings['colorSchemeCustomColors']['adminBarTopLevelHoverColor'],
	'adminBarSubmenuTextColor'                    => $slate_pro_settings['colorSchemeCustomColors']['adminBarSubmenuTextColor'],
	'adminBarSubmenuTextHoverColor'               => $slate_pro_settings['colorSchemeCustomColors']['adminBarSubmenuTextHoverColor'],
	'footerBgColor'                               => $slate_pro_settings['colorSchemeCustomColors']['footerBgColor'],
	'footerTextColor'                             => $slate_pro_settings['colorSchemeCustomColors']['footerTextColor'],
	'footerLinkColor'                             => $slate_pro_settings['colorSchemeCustomColors']['footerLinkColor'],
	'footerLinkHoverColor'                        => $slate_pro_settings['colorSchemeCustomColors']['footerLinkHoverColor'],
	'contentTextColor'                            => $slate_pro_settings['colorSchemeCustomColors']['contentTextColor'],
	'contentHeadingTextColor'                     => $slate_pro_settings['colorSchemeCustomColors']['contentHeadingTextColor'],
	'contentLinkColor'                            => $slate_pro_settings['colorSchemeCustomColors']['contentLinkColor'],
	'contentLinkHoverColor'                       => $slate_pro_settings['colorSchemeCustomColors']['contentLinkHoverColor'],
	'contentTableRowBgHoverColor'                 => $slate_pro_settings['colorSchemeCustomColors']['contentTableRowBgHoverColor'],
	'contentDividerColor'                         => $slate_pro_settings['colorSchemeCustomColors']['contentDividerColor'],
	'contentPrimaryButtonBgColor'                 => $slate_pro_settings['colorSchemeCustomColors']['contentPrimaryButtonBgColor'],
	'contentPrimaryButtonTextColor'               => $slate_pro_settings['colorSchemeCustomColors']['contentPrimaryButtonTextColor'],
	'contentPrimaryButtonBgHoverColor'            => $slate_pro_settings['colorSchemeCustomColors']['contentPrimaryButtonBgHoverColor'],
	'contentPrimaryButtonTextHoverColor'          => $slate_pro_settings['colorSchemeCustomColors']['contentPrimaryButtonTextHoverColor'],
	'contentStandardButtonBgColor'                => $slate_pro_settings['colorSchemeCustomColors']['contentStandardButtonBgColor'],
	'contentStandardButtonTextColor'              => $slate_pro_settings['colorSchemeCustomColors']['contentStandardButtonTextColor'],
	'contentStandardButtonBgHoverColor'           => $slate_pro_settings['colorSchemeCustomColors']['contentStandardButtonBgHoverColor'],
	'contentStandardButtonTextHoverColor'         => $slate_pro_settings['colorSchemeCustomColors']['contentStandardButtonTextHoverColor'],
	'contentMetaBgColor'                          => $slate_pro_settings['colorSchemeCustomColors']['contentMetaBgColor'],
	'contentMetaTextColor'                        => $slate_pro_settings['colorSchemeCustomColors']['contentMetaTextColor'],
	'contentMetaBgHoverColor'                     => $slate_pro_settings['colorSchemeCustomColors']['contentMetaBgHoverColor'],
	'contentMetaTextHoverColor'                   => $slate_pro_settings['colorSchemeCustomColors']['contentMetaTextHoverColor'],
	'sidebarBgColor'                              => $slate_pro_settings['colorSchemeCustomColors']['sidebarBgColor'],
	'sidebarTextColor'                            => $slate_pro_settings['colorSchemeCustomColors']['sidebarTextColor'],
	'sidebarHeadingColor'                         => $slate_pro_settings['colorSchemeCustomColors']['sidebarHeadingColor'],
	'sidebarLinkColor'                            => $slate_pro_settings['colorSchemeCustomColors']['sidebarLinkColor'],
	'sidebarLinkHoverColor'                       => $slate_pro_settings['colorSchemeCustomColors']['sidebarLinkHoverColor'],
	'sidebarIconColor'                            => $slate_pro_settings['colorSchemeCustomColors']['sidebarIconColor'],
	'sidebarDividerColor'                         => $slate_pro_settings['colorSchemeCustomColors']['sidebarDividerColor'],
	'sidebarPrimaryButtonBgColor'                 => $slate_pro_settings['colorSchemeCustomColors']['sidebarPrimaryButtonBgColor'],
	'sidebarPrimaryButtonTextColor'               => $slate_pro_settings['colorSchemeCustomColors']['sidebarPrimaryButtonTextColor'],
	'sidebarPrimaryButtonBgHoverColor'            => $slate_pro_settings['colorSchemeCustomColors']['sidebarPrimaryButtonBgHoverColor'],
	'sidebarPrimaryButtonTextHoverColor'          => $slate_pro_settings['colorSchemeCustomColors']['sidebarPrimaryButtonTextHoverColor'],
	'sidebarStandardButtonBgColor'                => $slate_pro_settings['colorSchemeCustomColors']['sidebarStandardButtonBgColor'],
	'sidebarStandardButtonTextColor'              => $slate_pro_settings['colorSchemeCustomColors']['sidebarStandardButtonTextColor'],
	'sidebarStandardButtonBgHoverColor'           => $slate_pro_settings['colorSchemeCustomColors']['sidebarStandardButtonBgHoverColor'],
	'sidebarStandardButtonTextHoverColor'         => $slate_pro_settings['colorSchemeCustomColors']['sidebarStandardButtonTextHoverColor'],
	'postStateBackground'                         => $slate_pro_settings['colorSchemeCustomColors']['postStateBackground'],
);