<?php
/**
 * This template displays product fee for products in product page.
 * 
 * This template can be overridden by copying it to your theme/extra-fees-for-woocommerce/templates/single/product-fee-notice.php.
 * 
 * To maintain compatibility, Extra Fees For WooCommerce will update the template files and you have to copy the updated files to your theme.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly
}

if ( $display_price ) {
	?>
	<p class="price">
		<?php
		if ( ! empty( $product->get_sale_price() ) ) {
			?>
			<del>
				<?php echo wp_kses_post( wc_price( $product->get_regular_price() ) ) ; ?>
			</del>
			<?php
			echo wp_kses_post( wc_price( $product->get_sale_price() ) ) ;
		} else {
			echo wp_kses_post( wc_price( $product->get_regular_price() ) ) ;
		}
		?>
	</p>
	<?php
}
$productfee = apply_filters( 'efw_product_fee_in_single_product_page' , $product_fee ) ;
?>
<table class="efw-fee-notice">
	<tr>
		<td>
			<?php
			echo esc_html( $fee_text ) ;
			?>
		</td>
		<td>
			<?php
			echo wp_kses_post( wc_price( $productfee ) ) ;
			?>
		</td>
	</tr>
	<tr>
		<td>
			<?php
			esc_html_e( 'Total Payable Amount' , 'extra-fees-for-woocommerce' ) ;
			?>
		</td>
		<td>
			<?php
			echo wp_kses_post( wc_price( $productfee + $price ) ) ;
			?>
		</td>
	</tr>
</table>
<?php
