<?php

/**
 * Enqueue Front End Enqueue Files
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'EFW_Frontend_Assets' ) ) {

	/**
	 * EFW_Frontend_Assets Class.
	 */
	class EFW_Frontend_Assets {

		/**
		 * EFW_Frontend_Assets Class Initialization.
		 */
		public static function init() {
			add_action( 'wp_enqueue_scripts' , array( __CLASS__ , 'external_js_files' ) , 99 ) ;
			add_action( 'wp_enqueue_scripts' , array( __CLASS__ , 'external_css_files' ) ) ;
		}

		/**
		 * Enqueue external css files.
		 */
		public static function external_css_files() {

			$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min' ;

			do_action( 'efw_frontend_after_enqueue_css' , $suffix ) ;
		}

		/**
		 * Enqueue Front end required JS files.
		 */
		public static function external_js_files() {

			$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min' ;

			$enqueue_array = array(
				'efw-frontend' => array(
					'callable' => array( 'EFW_Frontend_Assets' , 'frontend_script' ) ,
					'restrict' => true ,
				) ,
					) ;

			$enqueue_array = apply_filters( 'efw_frontend_enqueue_scripts' , $enqueue_array ) ;

			if ( ! efw_check_is_array( $enqueue_array ) ) {
				return ;
			}

			foreach ( $enqueue_array as $key => $enqueue ) {
				if ( ! efw_check_is_array( $enqueue ) ) {
					continue ;
				}

				if ( $enqueue[ 'restrict' ] ) {
					call_user_func_array( $enqueue[ 'callable' ] , array() ) ;
				}
			}

			do_action( 'efw_frontend_after_enqueue_js' , $suffix ) ;
		}

		/**
		 * Enqueue Section Frontend scripts.
		 */
		public static function frontend_script() {
			wp_enqueue_script( 'efw-frontend-script' , EFW_PLUGIN_URL . '/assets/js/frontend/frontend.js' , array( 'jquery' ) , EFW_VERSION ) ;
			wp_localize_script(
					'efw-frontend-script' , 'efw_frontend_param' , array(
				'fee_nonce'   => wp_create_nonce( 'efw-fee-nonce' ) ,
								'is_enabled'  => get_option( 'efw_productfee_enable' ) ,
				'is_checkout' => is_checkout() ,
				'is_product'  => is_product() ,
				'ajaxurl'     => EFW_ADMIN_AJAX_URL
					)
			) ;
		}

	}

	EFW_Frontend_Assets::init() ;
}
