<?php

/**
 * Initialize the plugin.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'EFW' ) ) {

	/**
	 * Main BS Class.
	 */
	final class EFW {

		/**
		 * EFW Version.
		 */
		public $version = '2.2' ;

		/**
		 * Background Process
		 * */
		protected $background_process ;

		/**
		 * The single instance of the class.
		 */
		protected static $_instance = null ;

		/**
		 * Load EFW Class in Single Instance.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self() ;
			}

			return self::$_instance ;
		}

		/**
		 * Cloning has been forbidden.
		 */
		public function __clone() {
			_doing_it_wrong( __FUNCTION__, 'You are not allowed to perform this action!!!', esc_html( $this->version ) ) ;
		}

		/**
		 * Unserialize the class data has been forbidden.
		 */
		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, 'You are not allowed to perform this action!!!', esc_html( $this->version ) ) ;
		}

		/**
		 * EFW Class Constructor.
		 */
		public function __construct() {
			/* Include once will help to avoid fatal error by load the files when you call init hook */
			include_once ABSPATH . 'wp-admin/includes/plugin.php' ;

			$this->header_already_sent_problem() ;
			$this->define_constants() ;
			$this->include_files() ;
			$this->init_hooks() ;
		}

		/**
		 * Function to Prevent Header Error that says You have already sent the header.
		 */
		private function header_already_sent_problem() {
			ob_start() ;
		}

		/**
		 * Initialize the Translate Files.
		 */
		private function load_plugin_textdomain() {
			if ( function_exists( 'determine_locale' ) ) {
				$locale = determine_locale() ;
			} else {
				// @todo Remove when start supporting WP 5.0 or later.
				$locale = is_admin() ? get_user_locale() : get_locale() ;
			}

			$locale = apply_filters( 'plugin_locale', $locale, 'extra-fees-for-woocommerce' ) ;

			unload_textdomain( 'extra-fees-for-woocommerce' ) ;
			load_textdomain( 'extra-fees-for-woocommerce', WP_LANG_DIR . '/extra-fees-for-woocommerce/extra-fees-for-woocommerce-' . $locale . '.mo' ) ;
			load_plugin_textdomain( 'extra-fees-for-woocommerce', false, dirname( plugin_basename( EFW_PLUGIN_FILE ) ) . '/languages' ) ;
		}

		/**
		 * Prepare the Constants value array.
		 */
		private function define_constants() {
			$protocol = 'http://' ;

			if ( isset( $_SERVER[ 'HTTPS' ] ) && ( 'on' == $_SERVER[ 'HTTPS' ] || 1 == $_SERVER[ 'HTTPS' ] ) || isset( $_SERVER[ 'HTTP_X_FORWARDED_PROTO' ] ) && 'https' == $_SERVER[ 'HTTP_X_FORWARDED_PROTO' ] ) {
				$protocol = 'https://' ;
			}

			global $wpdb ;
			$constant_array = array(
				'EFW_VERSION'        => $this->version,
				'EFW_FOLDER_NAME'    => 'extra-fees-for-woocommerce',
				'EFW_PROTOCOL'       => $protocol,
				'EFW_ABSPATH'        => dirname( EFW_PLUGIN_FILE ) . '/',
				'EFW_ADMIN_URL'      => admin_url( 'admin.php' ),
				'EFW_ADMIN_AJAX_URL' => admin_url( 'admin-ajax.php' ),
				'EFW_PLUGIN_SLUG'    => plugin_basename( EFW_PLUGIN_FILE ),
				'EFW_PLUGIN_PATH'    => untrailingslashit( plugin_dir_path( EFW_PLUGIN_FILE ) ),
				'EFW_PLUGIN_URL'     => untrailingslashit( plugins_url( '/', EFW_PLUGIN_FILE ) ),
					) ;

			$constant_array = apply_filters( 'efw_define_constants', $constant_array ) ;

			if ( is_array( $constant_array ) && ! empty( $constant_array ) ) {
				foreach ( $constant_array as $name => $value ) {
					$this->define_constant( $name, $value ) ;
				}
			}
		}

		/**
		 * Define the Constants value.
		 */
		private function define_constant( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value ) ;
			}
		}

		/**
		 * Include required files.
		 */
		private function include_files() {
			//Function
			include_once EFW_ABSPATH . 'inc/efw-common-functions.php' ;

			//Abstract
			include_once EFW_ABSPATH . 'inc/abstracts/class-efw-post.php' ;
			include_once EFW_ABSPATH . 'inc/class-efw-register-post-type.php' ;

			//Entity
			include_once EFW_ABSPATH . 'inc/entity/class-efw-fees.php' ;

			include_once EFW_ABSPATH . 'inc/class-efw-wc-log.php' ;

			include_once EFW_ABSPATH . 'inc/class-efw-install.php' ;
			include_once EFW_ABSPATH . 'inc/privacy/class-efw-privacy.php' ;
			include_once EFW_ABSPATH . 'inc/class-efw-date-time.php' ;

			include_once EFW_ABSPATH . 'inc/class-efw-fee-handler.php' ;

			if ( is_admin() ) {
				$this->include_admin_files() ;
			}

			if ( ! is_admin() || defined( 'DOING_AJAX' ) ) {
				$this->include_frontend_files() ;
			}
		}

		/**
		 * Include Admin End files.
		 */
		private function include_admin_files() {
			include_once EFW_ABSPATH . 'inc/admin/class-efw-admin-assets.php' ;
			include_once EFW_ABSPATH . 'inc/admin/class-efw-admin-ajax.php' ;
			include_once EFW_ABSPATH . 'inc/admin/class-efw-product-fee-settings.php' ;
			include_once EFW_ABSPATH . 'inc/admin/menu/class-efw-menu-management.php' ;
		}

		/**
		 * Include Front End files.
		 */
		private function include_frontend_files() {
			include_once EFW_ABSPATH . 'inc/frontend/class-efw-frontend-assets.php' ;
		}

		/**
		 * Define the hooks.
		 */
		private function init_hooks() {

			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) ) ;
			add_action( 'plugins_loaded', array( $this, 'other_plugin_support_includes' ), 20 ) ;

			// Init the plugin.
			add_action( 'init', array( $this, 'init' ) ) ;

			//Register the plugin.
			register_activation_hook( EFW_PLUGIN_FILE, array( 'EFW_Install', 'install' ) ) ;
		}

		/**
		 * Plugins Loaded
		 * */
		public function plugins_loaded() {
			do_action( 'efw_before_plugin_loaded' ) ;

			//Background process
			include_once EFW_ABSPATH . 'inc/background-updater/efw-background-process.php' ;

			$this->background_process = new EFW_Background_Process() ;

			do_action( 'efw_after_plugin_loaded' ) ;
		}

		/**
		 * Include classes for plugin support.
		 */
		public function other_plugin_support_includes() {
			include_once EFW_ABSPATH . 'inc/compatibilities/class-efw-wc-subscriptions-compat.php' ;

			if ( class_exists( 'WC_Subscriptions' ) ) {
				EFW_WC_Subscriptions_Compat::init() ;
			}
		}

		/**
		 * Init.
		 * */
		public function init() {

			$this->load_plugin_textdomain() ;
		}

		/**
		 * Templates.
		 */
		public function templates() {
			return EFW_PLUGIN_PATH . '/templates/' ;
		}

		/**
		 * Background Process
		 * */
		public function background_process() {
			return $this->background_process ;
		}

	}

}
