<?php

/*
 * Variable Product Fee Background Process
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ;
}
if ( ! class_exists( 'EFW_Variable_Product_Background_Process' ) ) {

	/**
	 * EFW_Variable_Product_Background_Process Class.
	 */
	class EFW_Variable_Product_Background_Process extends WP_Background_Process {

		/**
		 * Limit
		 */
		protected $limit = 1000 ;

		/**
				 * Action Id is assigned
				 * 
		 * @var string
		 */
		protected $action = 'efw_variable_product_background_updater' ;

		/**
		 * Trigger
		 */
		public function trigger() {
			if ( $this->is_process_running() ) {
				return ;
			}

			$posts = $this->get_posts() ;

			$this->handle_push_to_queue( $posts ) ;
		}

		/**
		 * Is process running
		 *
		 * Check whether the current process is already running
		 * in a background process.
		 */
		public function is_process_running() {
			if ( get_site_transient( $this->identifier . '_process_lock' ) ) {
				// Process already running.
				return true ;
			}

			return false ;
		}

		/**
		 * Handle push to queue
		 */
		protected function handle_push_to_queue( $posts, $offset = 0 ) {

			if ( efw_check_is_array( $posts ) ) {
				foreach ( $posts as $post_id ) {
					$args = array(
						'post_parent'    => $post_id ,
						'post_type'      => 'product_variation' ,
						'fields'         => 'ids' ,
						'post_status'    => 'publish' ,
						'posts_per_page' => -1
							) ;

					$variation_ids = get_posts( $args ) ;

					if ( efw_check_is_array( $variation_ids ) ) {
						foreach ( $variation_ids as $variation_id ) {
							$this->push_to_queue( $variation_id ) ;
						}
					} else {
						$this->push_to_queue( $post_id ) ;
					}
				}
			} else {
				$this->push_to_queue( 'no_old_data' ) ;
			}

			//update offset 
			set_transient( 'efw_variable_product_background_updater_offset' , ( $this->limit + $offset ) , 360 ) ;

			if ( 0 == $offset ) {
				EFW()->background_process()->update_progress_count( 60 ) ;
				EFW_WooCommerce_Log::log( 'Variable Product Fee Updation Started' ) ;
			}

			$this->save()->dispatch() ;
		}

		/**
		 * Posts
		 */
		protected function get_posts( $offset = 0 ) {

			$product_filter = get_option( 'efw_product_filter' ) ;

			if ( '1' == $product_filter ) {
				$args = array(
					'post_type'      => 'product_variation' ,
					'post_status'    => 'publish' ,
					'posts_per_page' => $this->limit ,
					'offset'         => $offset ,
					'sort_order'     => 'ASC' ,
					'fields'         => 'ids'
						) ;

				$product_ids = get_posts( $args ) ;
			} elseif ( '2' == $product_filter ) {
				$inc_products = get_option( 'efw_inc_products' ) ;
				$inc_products = efw_check_is_array( $inc_products ) ? $inc_products : ( ! empty( $inc_products ) ? explode( ',' , $inc_products ) : array() ) ;
				$args         = array(
					'post_type'      => 'product_variation' ,
					'post_status'    => 'publish' ,
					'posts_per_page' => $this->limit ,
					'offset'         => $offset ,
					'post__in'       => $inc_products ,
					'sort_order'     => 'ASC' ,
					'fields'         => 'ids'
						) ;

				$product_ids = get_posts( $args ) ;
			} elseif ( '3' == $product_filter ) {
				$exc_products = get_option( 'efw_exc_products' ) ;
				$exc_products = efw_check_is_array( $exc_products ) ? $exc_products : ( ! empty( $exc_products ) ? explode( ',' , $exc_products ) : array() ) ;
				$args         = array(
					'post_type'      => 'product_variation' ,
					'post_status'    => 'publish' ,
					'posts_per_page' => $this->limit ,
					'offset'         => $offset ,
					'post__not_in'   => $exc_products ,
					'sort_order'     => 'ASC' ,
					'fields'         => 'ids'
						) ;

				$product_ids = get_posts( $args ) ;
			} elseif ( '4' == $product_filter ) {
				$args = array(
					'post_type'      => 'product' ,
					'post_status'    => 'publish' ,
					'posts_per_page' => $this->limit ,
					'offset'         => $offset ,
					'tax_query'      => array(
						array(
							'taxonomy' => 'product_cat' ,
							'field'    => 'term_id' ,
							'terms'    => get_option( 'efw_inc_category' ) ,
							'operator' => 'IN'
						)
					) ,
					'fields'         => 'ids'
						) ;

				$product_ids = get_posts( $args ) ;
			} else {
				$args = array(
					'post_type'      => 'product' ,
					'post_status'    => 'publish' ,
					'posts_per_page' => $this->limit ,
					'offset'         => $offset ,
					'tax_query'      => array(
						array(
							'taxonomy' => 'product_cat' ,
							'field'    => 'term_id' ,
							'terms'    => get_option( 'efw_exc_category' ) ,
							'operator' => 'NOT IN'
						)
					) ,
					'fields'         => 'ids'
						) ;

				$product_ids = get_posts( $args ) ;
			}

			return $product_ids ;
		}

		/**
		 * Task
		 *
		 * Override this method to perform any actions required on each
		 * queue item. Return the modified item for further processing
		 * in the next pass through. Or, return false to remove the
		 * item from the queue.
		 *
		 * @param mixed $item Queue item to iterate over
		 *
		 * @return mixed
		 */
		protected function task( $product_id ) {
			if ( 'no_old_data' == $product_id ) {
				return false ;
			}

			$enable_fee = get_option( 'efw_bulk_enable_fee' ) ;
			update_post_meta( $product_id , '_efw_enable_fee' , $enable_fee ) ;

			$text_from = get_option( 'efw_text_from' ) ;
			update_post_meta( $product_id , '_efw_text_from' , $text_from ) ;

			$fee_text = get_option( 'efw_fee_text' ) ;
			update_post_meta( $product_id , '_efw_fee_text' , $fee_text ) ;

			$fee_type = get_option( 'efw_fee_type' ) ;
			update_post_meta( $product_id , '_efw_fee_type' , $fee_type ) ;

			if ( '1' == $fee_type ) {
				$fixed_value = get_option( 'efw_fixed_value' ) ;
				update_post_meta( $product_id , '_efw_fixed_value' , $fixed_value ) ;
			} else {
				$percent_value = get_option( 'efw_percent_value' ) ;
				update_post_meta( $product_id , '_efw_percent_value' , $percent_value ) ;
			}

			return false ;
		}

		/**
		 * Complete
		 */
		protected function complete() {
			parent::complete() ;

			$offset = get_transient( 'efw_variable_product_background_updater_offset' ) ;
			$posts  = $this->get_posts( $offset ) ;

			if ( efw_check_is_array( $posts ) ) {
				$this->handle_push_to_queue( $posts , $offset ) ;
				EFW_WooCommerce_Log::log( 'Product Fee for Simple upto ' . $offset ) ;
			} else {
				EFW()->background_process()->update_progress_count( 100 ) ;
				delete_transient( 'efw_variable_product_background_updater_offset' ) ;
				EFW_WooCommerce_Log::log( 'Variable Product Fee Update Completed' ) ;
			}
		}

	}

}
