<?php
/* Admin HTML Fee Settings for Simple Product */

if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="show_if_simple efw-fee-wrapper">
	<p class="form-field">
		<label><?php esc_html_e( 'Enable Product Fee' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="checkbox" class="efw_enable_fee" name="efw_enable_fee" <?php echo checked( $enable , 'yes' , true ) ; ?>/>
	</p>
	<p class="form-field efw-show-if-extra-fee-enable">
		<label><?php esc_html_e( 'Fee Text is Obtained from' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select name="efw_text_from" class="efw_text_from">
			<option value="1" <?php selected( $fee_text_from , '1' , true ) ; ?>><?php esc_html_e( 'Global Level Settings' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="2" <?php selected( $fee_text_from , '2' , true ) ; ?>><?php esc_html_e( 'Product Level Settings' , 'extra-fees-for-woocommerce' ) ; ?></option>
		</select>
	</p>
	<p class="form-field efw-extra-fee-text efw-show-if-extra-fee-enable">
		<label><?php esc_html_e( 'Fee Text' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="text" name="efw_fee_text" value="<?php echo esc_attr( $fee_text ) ; ?>"/>
	</p>
	<p class="form-field efw-show-if-extra-fee-enable">
		<label><?php esc_html_e( 'Fee Type' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select name="efw_fee_type" class="efw_extra_fee_type">
			<option value="1" <?php selected( $fee_type , '1' , true ) ; ?>><?php esc_html_e( 'Fixed Fee' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="2" <?php selected( $fee_type , '2' , true ) ; ?>><?php esc_html_e( 'Percentage of Product Price' , 'extra-fees-for-woocommerce' ) ; ?></option>
		</select>
	</p>
	<p class="form-field efw-fixed-type efw-show-if-extra-fee-enable">
		<label><?php esc_html_e( 'Fixed Fee Value' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="number" step="any" min="0" name="efw_fixed_value" value="<?php echo esc_attr( $fixed_value ) ; ?>"/>
	</p>
	<p class="form-field efw-percent-type efw-show-if-extra-fee-enable">
		<label><?php esc_html_e( 'Fee Value in %' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="number" step="any" min="0" name="efw_percent_value" value="<?php echo esc_attr( $percent_value ) ; ?>"/>
	</p>
</div>
<?php
