<?php
/* Admin HTML Fee Settings for Gateway */

if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="efw-gateway-fee-settings">
	<h3><?php echo esc_html( $gateway_title ) ; ?></h3>
	<p>
		<label><?php esc_html_e( 'Enable Fee for this Payment Gateway' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="checkbox" class="efw-enable-gateway-fee" name="efw_enable_fee_for_<?php echo esc_attr( $gateway_id ) ; ?>" <?php checked( $enable_deal , 'yes' , true ) ; ?>/>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( 'Fee should apply for' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw-user-filter-type" name="efw_user_filter_type_for_<?php echo esc_attr( $gateway_id ) ; ?>">
			<option value="1" <?php echo selected( $user_filter_type , '1' , true ) ; ?>><?php esc_html_e( 'All User(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="2" <?php echo selected( $user_filter_type , '2' , true ) ; ?>><?php esc_html_e( 'Include User(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="3" <?php echo selected( $user_filter_type , '3' , true ) ; ?>><?php esc_html_e( 'Exclude User(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="4" <?php echo selected( $user_filter_type , '4' , true ) ; ?>><?php esc_html_e( 'Include User Role(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="5" <?php echo selected( $user_filter_type , '5' , true ) ; ?>><?php esc_html_e( 'Exclude User Role(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
		</select>
	</p>
	<p class="efw-show-if-enable efw-include-user">
		<label><?php esc_html_e( 'Select User(s) to Include' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<?php
		$include_user_args = array(
			'name'                    => 'efw_include_user_for_' . $gateway_id ,
			'list_type'               => 'customers' ,
			'exclude_global_variable' => 'yes' ,
			'action'                  => 'efw_customers_search' ,
			'placeholder'             => esc_html__( 'Search a User' , 'extra-fees-for-woocommerce' ) ,
			'options'                 => $include_user ,
				) ;
		efw_select2_html( $include_user_args ) ;
		?>
	</p>
	<p class="efw-show-if-enable efw-exclude-user">
		<label><?php esc_html_e( 'Select User(s) to Exclude' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<?php
		$exclude_user_args = array(
			'name'                    => 'efw_exclude_user_for_' . $gateway_id ,
			'list_type'               => 'customers' ,
			'exclude_global_variable' => 'yes' ,
			'action'                  => 'efw_customers_search' ,
			'placeholder'             => esc_html__( 'Search a User' , 'extra-fees-for-woocommerce' ) ,
			'options'                 => $exclude_user ,
				) ;
		efw_select2_html( $exclude_user_args ) ;
		?>
	</p>
	<p class="efw-show-if-enable efw-include-user-role">
		<label><?php esc_html_e( 'Select User Role(s) to Include' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw_select2" name="efw_include_userrole_for_<?php echo esc_attr( $gateway_id ) ; ?>[]" multiple="multiple">
			<?php
			foreach ( efw_get_user_roles() as $user_role_id => $user_role_name ) :
				$selected = ( in_array( $user_role_id , ( array ) $include_user_role ) ) ? ' selected="selected"' : '' ;
				?>
				<option value="<?php echo esc_attr( $user_role_id ) ; ?>"<?php echo esc_attr( $selected ) ; ?>><?php echo esc_html( $user_role_name ) ; ?></option>
			<?php endforeach ; ?>
		</select>
	</p>
	<p class="efw-show-if-enable efw-exclude-user-role">
		<label><?php esc_html_e( 'Select User Role(s) to Exclude' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw_select2" name="efw_exclude_userrole_for_<?php echo esc_attr( $gateway_id ) ; ?>[]" multiple="multiple">
			<?php
			foreach ( efw_get_user_roles() as $user_role_id => $user_role_name ) :
				$selected = ( in_array( $user_role_id , ( array ) $exclude_user_role ) ) ? ' selected="selected"' : '' ;
				?>
				<option value="<?php echo esc_attr( $user_role_id ) ; ?>"<?php echo esc_attr( $selected ) ; ?>><?php echo esc_html( $user_role_name ) ; ?></option>
			<?php endforeach ; ?>
		</select>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( 'Fee for Product(s)/Categories' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw-product-filter-type" name="efw_product_filter_type_for_<?php echo esc_attr( $gateway_id ) ; ?>">
			<option value="1" <?php echo selected( $product_filter_type , '1' , true ) ; ?>><?php esc_html_e( 'All Product(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="2" <?php echo selected( $product_filter_type , '2' , true ) ; ?>><?php esc_html_e( 'Include Product(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="3" <?php echo selected( $product_filter_type , '3' , true ) ; ?>><?php esc_html_e( 'Exclude Product(s)' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="4" <?php echo selected( $product_filter_type , '4' , true ) ; ?>><?php esc_html_e( 'Include Categories' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="5" <?php echo selected( $product_filter_type , '5' , true ) ; ?>><?php esc_html_e( 'Exclude Categories' , 'extra-fees-for-woocommerce' ) ; ?></option>
		</select>
	</p>
	<p class="efw-show-if-enable efw-include-product">
		<label><?php esc_html_e( 'Select Product(s) to Include' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<?php
		$include_product_args = array(
			'name'                    => 'efw_include_product_for_' . $gateway_id ,
			'list_type'               => 'products' ,
			'exclude_global_variable' => 'yes' ,
			'action'                  => 'efw_product_search' ,
			'placeholder'             => esc_html__( 'Search a Product' , 'extra-fees-for-woocommerce' ) ,
			'options'                 => $include_product ,
				) ;
		efw_select2_html( $include_product_args ) ;
		?>
	</p>
	<p class="efw-show-if-enable efw-exclude-product">
		<label><?php esc_html_e( 'Select Product(s) to Exclude' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<?php
		$exclude_product_args = array(
			'name'                    => 'efw_exclude_product_for_' . $gateway_id ,
			'list_type'               => 'products' ,
			'exclude_global_variable' => 'yes' ,
			'action'                  => 'efw_product_search' ,
			'placeholder'             => esc_html__( 'Search a Product' , 'extra-fees-for-woocommerce' ) ,
			'options'                 => $exclude_product ,
				) ;
		efw_select2_html( $exclude_product_args ) ;
		?>
	</p>
	<p class="efw-show-if-enable efw-include-category">
		<label><?php esc_html_e( 'Select Categories to Include' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw_select2" name="efw_include_category_for_<?php echo esc_attr( $gateway_id ) ; ?>[]" multiple="multiple">
			<?php
			foreach ( efw_get_wc_categories() as $category_id => $category_name ) :
				$selected = ( in_array( $category_id , ( array ) $include_category ) ) ? ' selected="selected"' : '' ;
				?>
				<option value="<?php echo esc_attr( $category_id ) ; ?>"<?php echo esc_attr( $selected ) ; ?>><?php echo esc_html( $category_name ) ; ?></option>
			<?php endforeach ; ?>
		</select>
	</p>
	<p class="efw-show-if-enable efw-exclude-category">
		<label><?php esc_html_e( 'Select Categories to Exclude' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw_select2" name="efw_exclude_category_for_<?php echo esc_attr( $gateway_id ) ; ?>[]" multiple="multiple">
			<?php
			foreach ( efw_get_wc_categories() as $category_id => $category_name ) :
				$selected = ( in_array( $category_id , ( array ) $exclude_category ) ) ? ' selected="selected"' : '' ;
				?>
				<option value="<?php echo esc_attr( $category_id ) ; ?>"<?php echo esc_attr( $selected ) ; ?>><?php echo esc_html( $category_name ) ; ?></option>
			<?php endforeach ; ?>
		</select>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( 'Date Ranges' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<?php
		$rule_valid_from_date_args = array(
			'name'        => 'efw_from_date_for_' . $gateway_id ,
			'value'       => $from_date ,
			'wp_zone'     => false ,
			'placeholder' => EFW_Date_Time::get_wp_date_format() ,
				) ;
		efw_get_datepicker_html( $rule_valid_from_date_args ) ;
		?>
		<?php esc_html_e( 'To' , 'extra-fees-for-woocommerce' ) ; ?>
		<?php
		$rule_valid_to_date_args   = array(
			'name'        => 'efw_to_date_for_' . $gateway_id ,
			'value'       => $to_date ,
			'wp_zone'     => false ,
			'placeholder' => EFW_Date_Time::get_wp_date_format() ,
				) ;
		efw_get_datepicker_html( $rule_valid_to_date_args ) ;
		?>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( 'Fee Text' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input name="efw_fee_text_for_<?php echo esc_attr( $gateway_id ) ; ?>" value="<?php echo esc_html( $fee_text ) ; ?>"/>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( 'Tax Class' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select name="efw_tax_class_for_<?php echo esc_attr( $gateway_id ) ; ?>">
			<option value="not-required" <?php echo selected( $tax_class , 'not-required' , true ) ; ?>><?php esc_html_e( 'Not required' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="standard" <?php echo selected( $tax_class , 'standard' , true ) ; ?>><?php esc_html_e( 'Standard' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="reduced-rate" <?php echo selected( $tax_class , 'reduced-rate' , true ) ; ?>><?php esc_html_e( 'Reduced rate' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="zero-rate" <?php echo selected( $tax_class , 'zero-rate' , true ) ; ?>><?php esc_html_e( 'Zero rate' , 'extra-fees-for-woocommerce' ) ; ?></option>
		</select>
		<?php echo wc_help_tip( 'Select the tax which should be used for calculating the fee' ) ; ?>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( 'Fee Type' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw-fee-type" name="efw_fee_type_for_<?php echo esc_attr( $gateway_id ) ; ?>">
			<option value="1" <?php echo selected( $fee_type , '1' , true ) ; ?>><?php esc_html_e( 'Fixed Fee' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="2" <?php echo selected( $fee_type , '2' , true ) ; ?>><?php esc_html_e( 'Percentage' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="3" <?php echo selected( $fee_type , '3' , true ) ; ?>><?php esc_html_e( 'Fixed + Percentage' , 'extra-fees-for-woocommerce' ) ; ?></option>
		</select>
	</p>
		<p class="efw-show-if-enable efw-percentage-type">
		<label><?php esc_html_e( 'Percentage based on' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<select class="efw-percentage-type" name="efw_percentage_type_for_<?php echo esc_attr( $gateway_id ) ; ?>">
			<option value="1" <?php echo selected( $percentage_type , '1' , true ) ; ?>><?php esc_html_e( 'Cart Subtotal' , 'extra-fees-for-woocommerce' ) ; ?></option>
			<option value="2" <?php echo selected( $percentage_type , '2' , true ) ; ?>><?php esc_html_e( 'Order Total' , 'extra-fees-for-woocommerce' ) ; ?></option>
		</select>
	</p>
	<p class="efw-show-if-enable efw-fixed-fee">
		<label><?php esc_html_e( 'Fixed Fee Value' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="number" min="0" step="any" name="efw_fixed_value_for_<?php echo esc_attr( $gateway_id ) ; ?>" value="<?php echo esc_html( $fixed_value ) ; ?>"/>
	</p>
	<p class="efw-show-if-enable efw-percent-cart-subtotal">
		<label><?php esc_html_e( 'Fee Value in %' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="number" min="0" step="any" name="efw_percent_value_of_cart_subtotal_for_<?php echo esc_attr( $gateway_id ) ; ?>" value="<?php echo esc_html( $percent_of_cart_subtotal ) ; ?>"/>
	</p>
	<p class="efw-show-if-enable efw-minimum-fee">
		<label><?php esc_html_e( 'Minimum Fee' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="number" min="0" name="efw_min_fee_for_<?php echo esc_attr( $gateway_id ) ; ?>" value="<?php echo esc_html( $min_fee ) ; ?>"/>
		<?php echo wc_help_tip( 'The fee value configured in this field will consider when the fee is calculated less than the minimum fee' ) ; ?>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( 'Minimum Cart Subtotal/Order Total to Add Fee' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="number" min="0" name="efw_min_subtotal_for_<?php echo esc_attr( $gateway_id ) ; ?>" value="<?php echo esc_html( $min_total ) ; ?>"/>
		<?php echo wc_help_tip( 'The minimum subtotal which is required to add a fee' ) ; ?>
	</p>
	<p class="efw-show-if-enable">
		<label><?php esc_html_e( ' Maximum Cart Subtotal/Order Total to Add Fee' , 'extra-fees-for-woocommerce' ) ; ?></label>
		<input type="number" min="0" name="efw_max_subtotal_for_<?php echo esc_attr( $gateway_id ) ; ?>" value="<?php echo esc_html( $max_total ) ; ?>"/>
		<?php echo wc_help_tip( 'The maximum subtotal above which the fee will not be added' ) ; ?>
	</p>
</div>
<?php
