<?php

/**
 * Product Fee Tab.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( class_exists( 'EFW_Product_Fee_Tab' ) ) {
	return new EFW_Product_Fee_Tab() ;
}

/**
 * EFW_Product_Fee_Tab.
 */
class EFW_Product_Fee_Tab extends EFW_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'productfee' ;
		$this->label = esc_html__( 'Product Fee' , 'extra-fees-for-woocommerce' ) ;

		parent::__construct() ;

		//Validate Settings for Before Save.
		add_filter( 'efw_validate_settings_before_save' , array( $this , 'validate_before_save' ) ) ;
	}

	/**
	 * Get Product Fee Settings section array.
	 */
	public function productfee_section_array() {
		$section_fields = array() ;

		$section_fields[] = array(
			'type'      => 'efw_custom_fields' ,
			'efw_field' => 'section_start' ,
				) ;
		$section_fields[] = array(
			'type'  => 'title' ,
			'title' => esc_html__( 'Product Fee Settings' , 'extra-fees-for-woocommerce' ) ,
			'id'    => 'efw_product_fee_settings' ,
				) ;
		$section_fields[] = array(
			'title'   => esc_html__( 'Enable Product Fee' , 'extra-fees-for-woocommerce' ) ,
			'type'    => 'checkbox' ,
			'default' => 'no' ,
			'id'      => $this->get_option_key( 'enable' ) ,
			'desc'    => esc_html__( 'When enabled, a fee will be added to the product\'s price' , 'extra-fees-for-woocommerce' ) ,
				) ;
		$section_fields[] = array(
			'title'   => esc_html__( 'Fee Text' , 'extra-fees-for-woocommerce' ) ,
			'type'    => 'text' ,
			'default' => '' ,
			'id'      => $this->get_option_key( 'fee_text' ) ,
			'class'   => 'show-if-product-fee-enable' ,
				) ;
		$section_fields[] = array(
			'title'   => esc_html__( 'Add to Cart Label in Shop Page' , 'extra-fees-for-woocommerce' ) ,
			'type'    => 'text' ,
			'default' => 'View Final Price' ,
			'id'      => $this->get_option_key( 'add_to_cart_label' ) ,
			'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
			'title'   => esc_html__( 'Fee should apply for' , 'extra-fees-for-woocommerce' ) ,
			'type'    => 'select' ,
			'default' => '1' ,
			'id'      => $this->get_option_key( 'user_filter' ) ,
			'options' => array(
				'1' => esc_html__( 'All Users' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Include User(s)' , 'extra-fees-for-woocommerce' ) ,
				'3' => esc_html__( 'Exclude User(s)' , 'extra-fees-for-woocommerce' ) ,
				'4' => esc_html__( 'Include User Role(s)' , 'extra-fees-for-woocommerce' ) ,
				'5' => esc_html__( 'Exclude User Role(s)' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select User(s) to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'customers' ,
						'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_customers_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'include_users' ) ,
				'class'                   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select User(s) to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'customers' ,
				'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_customers_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'exclude_users' ) ,
				'class'                   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select User Role(s) to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-product-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_user_roles() ,
				'id'      => $this->get_option_key( 'include_userrole' ) ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select User Role(s) to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-product-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_user_roles() ,
				'id'      => $this->get_option_key( 'exclude_userrole' ) ,
				) ;
				$section_fields[] = array(
				'title'    => esc_html__( 'Fee Calculation Mode' , 'extra-fees-for-woocommerce' ) ,
				'type'     => 'radio' ,
				'default'  => '1' ,
				'options'  => array(
				'1' => esc_html__( 'Quick Setup' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Advanced Setup' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'id'       => $this->get_option_key( 'fee_setup' ) ,
				'class'    => 'efw_productfee_fee_setup show-if-product-fee-enable' ,
				'desc'     => esc_html__( 'Quick Setup: A common fee will be added to all the products sold on the site. Advanced Setup: A separate fee can be set for each product on the product configuration page.' , 'extra-fees-for-woocommerce' ) ,
				'desc_tip' => true ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Product Fee is Applicable for' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'select' ,
				'default' => '1' ,
				'id'      => $this->get_option_key( 'apply_for' ) ,
				'options' => array(
				'1' => esc_html__( 'All Products' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Include Product(s)' , 'extra-fees-for-woocommerce' ) ,
				'3' => esc_html__( 'Exclude Product(s)' , 'extra-fees-for-woocommerce' ) ,
				'4' => esc_html__( 'Include Categories' , 'extra-fees-for-woocommerce' ) ,
				'5' => esc_html__( 'Exclude Categories' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select Product(s) to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'products' ,
				'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_product_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'include_products' ) ,
				'class'                   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select Product(s) to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'products' ,
				'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_product_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'exclude_products' ) ,
				'class'                   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select Categories to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-product-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_wc_categories() ,
				'id'      => $this->get_option_key( 'include_category' ) ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select Categories to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-product-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_wc_categories() ,
				'id'      => $this->get_option_key( 'exclude_category' ) ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Fee Type' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'select' ,
				'default' => '1' ,
				'id'      => $this->get_option_key( 'fee_type' ) ,
				'options' => array(
				'1' => esc_html__( 'Fixed Fee' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Percentage of Product Price' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Fixed Fee Value' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' , 'step' => 'any' ) ,
				'id'                => $this->get_option_key( 'fixed_value' ) ,
				'class'             => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Fee Value in %' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' , 'step' => 'any' ) ,
				'id'                => $this->get_option_key( 'percent_value' ) ,
				'class'             => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'type' => 'sectionend' ,
				'id'   => 'efw_product_fee_settings' ,
				) ;
				$section_fields[] = array(
				'type'  => 'title' ,
				'title' => esc_html__( 'Product Fee Bulk Update Settings' , 'extra-fees-for-woocommerce' ) ,
				'id'    => 'efw_product_fee_bulk_settings' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Product/Category Selection' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'select' ,
				'default' => '1' ,
				'id'      => $this->get_option_key( 'product_filters' ) ,
				'options' => array(
				'1' => esc_html__( 'All Product(s)' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Include Product(s)' , 'extra-fees-for-woocommerce' ) ,
				'3' => esc_html__( 'Exclude Product(s)' , 'extra-fees-for-woocommerce' ) ,
				'4' => esc_html__( 'Include Categories' , 'extra-fees-for-woocommerce' ) ,
				'5' => esc_html__( 'Exclude Categories' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select Product(s) to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'products' ,
				'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_product_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'update_inc_products' ) ,
				'class'                   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select Product(s) to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'products' ,
				'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_product_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'update_exc_products' ) ,
				'class'                   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select Categories to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-product-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_wc_categories() ,
				'id'      => $this->get_option_key( 'update_inc_category' ) ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select Categories to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-product-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_wc_categories() ,
				'id'      => $this->get_option_key( 'update_exc_category' ) ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Enable Product Fee' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'checkbox' ,
				'default' => 'no' ,
				'id'      => $this->get_option_key( 'bulk_enable' ) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Fee Text is Obtained from' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'select' ,
				'default' => '1' ,
				'id'      => $this->get_option_key( 'bulk_text_from' ) ,
				'options' => array(
				'1' => esc_html__( 'Global Level Settings' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Product Level Settings' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Fee Text' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'text' ,
				'default' => '' ,
				'id'      => $this->get_option_key( 'bulk_fee_text' ) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Fee Type' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'select' ,
				'default' => '1' ,
				'id'      => $this->get_option_key( 'bulk_fee_type' ) ,
				'options' => array(
				'1' => esc_html__( 'Fixed Fee' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Percentage of Product Price' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Fixed Fee Value' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' , 'step' => 'any' ) ,
				'id'                => $this->get_option_key( 'bulk_fixed_value' ) ,
				'class'             => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Fee Value in %' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' , 'step' => 'any' ) ,
				'id'                => $this->get_option_key( 'bulk_percent_value' ) ,
				'class'             => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'     => esc_html__( 'Update' , 'extra-fees-for-woocommerce' ) ,
				'type'      => 'efw_custom_fields' ,
				'efw_field' => 'button' ,
				'id'        => $this->get_option_key( 'bulk_update' ) ,
				'class'     => 'show-if-product-fee-enable' ,
				) ;
				$section_fields[] = array(
				'type' => 'sectionend' ,
				'id'   => 'efw_product_fee_bulk_settings' ,
				) ;
				$section_fields[] = array(
				'type'      => 'efw_custom_fields' ,
				'efw_field' => 'section_end' ,
				) ;

				return $section_fields ;
	}

	/**
	 * Validate the Fields before Save.
	 */
	public static function validate_before_save( $bool ) {
		if ( isset( $_REQUEST[ 'efw_productfee_enable' ] ) && isset( $_REQUEST[ 'efw_productfee_fee_setup' ] ) ) {

			if ( isset( $_REQUEST[ 'efw_productfee_fee_text' ] ) && empty( $_REQUEST[ 'efw_productfee_fee_text' ] ) ) {
				EFW_Settings::add_error( esc_html__( 'Fee Text field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
				$bool = false ;
			}

			if ( '1' == $_REQUEST[ 'efw_productfee_fee_setup' ] ) {
				if ( isset( $_REQUEST[ 'efw_productfee_fee_type' ] ) ) {
					if ( '1' == $_REQUEST[ 'efw_productfee_fee_type' ] ) {
						if ( isset( $_REQUEST[ 'efw_productfee_fixed_value' ] ) && empty( $_REQUEST[ 'efw_productfee_fixed_value' ] ) ) {
							EFW_Settings::add_error( esc_html__( 'Fixed Fee Value field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
							$bool = false ;
						}
					}

					if ( '2' == $_REQUEST[ 'efw_productfee_fee_type' ] ) {
						if ( isset( $_REQUEST[ 'efw_productfee_percent_value' ] ) && empty( $_REQUEST[ 'efw_productfee_percent_value' ] ) ) {
							EFW_Settings::add_error( esc_html__( 'Fee Value in Percent field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
							$bool = false ;
						}
					}
				}
			}
		}

		return $bool ;
	}

}

return new EFW_Product_Fee_Tab() ;
