<?php

/**
 * Order Total Fee Tab.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( class_exists( 'EFW_Order_Total_Fee_Tab' ) ) {
	return new EFW_Order_Total_Fee_Tab() ;
}

/**
 * EFW_Order_Total_Fee_Tab.
 */
class EFW_Order_Total_Fee_Tab extends EFW_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'ordertotalfee' ;
		$this->label = esc_html__( 'Order Fee' , 'extra-fees-for-woocommerce' ) ;

		parent::__construct() ;

		//Validate Settings for Before Save.
		add_filter( 'efw_validate_settings_before_save' , array( $this , 'validate_before_save' ) ) ;
	}

	/**
	 * Get Order Total Fee Settings section array.
	 */
	public function ordertotalfee_section_array() {
		$section_fields = array() ;

		$section_fields[] = array(
			'type'      => 'efw_custom_fields' ,
			'efw_field' => 'section_start' ,
				) ;
		$section_fields[] = array(
			'type'  => 'title' ,
			'title' => esc_html__( 'Order Fee Settings' , 'extra-fees-for-woocommerce' ) ,
			'id'    => 'efw_order_total_fee_settings' ,
				) ;
		$section_fields[] = array(
			'title'   => esc_html__( 'Enable Order Fee' , 'extra-fees-for-woocommerce' ) ,
			'type'    => 'checkbox' ,
			'default' => 'no' ,
			'desc'    => esc_html__( 'When enabled, a fee has to be paid by the user for purchasing within the specified range' , 'extra-fees-for-woocommerce' ) ,
			'id'      => $this->get_option_key( 'enable' ) ,
				) ;
		$section_fields[] = array(
			'title'   => esc_html__( 'Fee Text' , 'extra-fees-for-woocommerce' ) ,
			'type'    => 'text' ,
			'default' => '' ,
			'id'      => $this->get_option_key( 'fee_text' ) ,
			'class'   => 'show-if-order-fee-enable' ,
				) ;
		$section_fields[] = array(
			'title'    => esc_html__( 'Tax Class' , 'extra-fees-for-woocommerce' ) ,
			'type'     => 'select' ,
			'default'  => '1' ,
			'id'       => $this->get_option_key( 'tax_class' ) ,
			'options'  => array(
				'not-required' => esc_html__( 'Not required' , 'extra-fees-for-woocommerce' ) ,
				'standard'     => esc_html__( 'Standard' , 'extra-fees-for-woocommerce' ) ,
				'reduced-rate' => esc_html__( 'Reduced rate' , 'extra-fees-for-woocommerce' ) ,
				'zero-rate'    => esc_html__( 'Zero rate' , 'extra-fees-for-woocommerce' ) ,
			) ,
			'desc_tip' => true ,
			'desc'     => esc_html__( 'Select the tax which should be used for calculating the fee' , 'extra-fees-for-woocommerce' ) ,
			'class'    => 'show-if-order-fee-enable' ,
				) ;
		$section_fields[] = array(
			'title'    => esc_html__( 'Exclude Shipping Method(s)' , 'extra-fees-for-woocommerce' ) ,
			'type'     => 'multiselect' ,
			'class'    => 'efw_select2 show-if-order-fee-enable' ,
			'default'  => '' ,
			'id'       => $this->get_option_key( 'excluded_shipping' ) ,
			'options'  => efw_get_wc_shipping_methods() ,
			'desc_tip' => true ,
			'desc'     => esc_html__( 'Order fee will not be charged for the shipping method(s) selected in this option.' , 'extra-fees-for-woocommerce' ) ,
				) ;
				$section_fields[] = array(
			'title'   => esc_html__( 'Fee should apply for' , 'extra-fees-for-woocommerce' ) ,
			'type'    => 'select' ,
			'default' => '1' ,
			'id'      => $this->get_option_key( 'user_filter' ) ,
			'options' => array(
				'1' => esc_html__( 'All Users' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Include User(s)' , 'extra-fees-for-woocommerce' ) ,
				'3' => esc_html__( 'Exclude User(s)' , 'extra-fees-for-woocommerce' ) ,
				'4' => esc_html__( 'Include User Role(s)' , 'extra-fees-for-woocommerce' ) ,
				'5' => esc_html__( 'Exclude User Role(s)' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select User(s) to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'customers' ,
						'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_customers_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'include_users' ) ,
				'class'                   => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'                   => esc_html__( 'Select User(s) to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'                    => 'efw_custom_fields' ,
				'efw_field'               => 'ajaxmultiselect' ,
				'list_type'               => 'customers' ,
				'exclude_global_variable' => 'yes' ,
				'action'                  => 'efw_customers_search' ,
				'default'                 => array() ,
				'allow_clear'             => false ,
				'id'                      => $this->get_option_key( 'exclude_users' ) ,
				'class'                   => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select User Role(s) to Include' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-order-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_user_roles() ,
				'id'      => $this->get_option_key( 'include_userrole' ) ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Select User Role(s) to Exclude' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'multiselect' ,
				'class'   => 'efw_select2 show-if-order-fee-enable' ,
				'default' => '' ,
				'options' => efw_get_user_roles() ,
				'id'      => $this->get_option_key( 'exclude_userrole' ) ,
				) ;
				$section_fields[] = array(
				'title'   => esc_html__( 'Fee Type' , 'extra-fees-for-woocommerce' ) ,
				'type'    => 'select' ,
				'default' => '1' ,
				'id'      => $this->get_option_key( 'fee_type' ) ,
				'options' => array(
				'1' => esc_html__( 'Fixed Fee' , 'extra-fees-for-woocommerce' ) ,
				'2' => esc_html__( 'Percentage of Cart Subtotal' , 'extra-fees-for-woocommerce' ) ,
				) ,
				'class'   => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Fixed Fee Value' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' , 'step' => 'any' ) ,
				'id'                => $this->get_option_key( 'fixed_value' ) ,
				'class'             => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Fee Value in %' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' , 'step' => 'any' ) ,
				'id'                => $this->get_option_key( 'cart_subtotal_percentage' ) ,
				'class'             => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Minimum Cart Subtotal to Add Fee' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' ) ,
				'id'                => $this->get_option_key( 'min_sub_total' ) ,
				'desc_tip'          => true ,
				'desc'              => esc_html__( 'The minimum subtotal which is required to add a fee' , 'extra-fees-for-woocommerce' ) ,
				'class'             => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'title'             => esc_html__( 'Maximum Cart Subtotal to Add Fee' , 'extra-fees-for-woocommerce' ) ,
				'type'              => 'number' ,
				'default'           => '' ,
				'custom_attributes' => array( 'min' => '0' ) ,
				'id'                => $this->get_option_key( 'max_sub_total' ) ,
				'desc_tip'          => true ,
				'desc'              => esc_html__( 'The maximum subtotal above which the fee will not be added' , 'extra-fees-for-woocommerce' ) ,
				'class'             => 'show-if-order-fee-enable' ,
				) ;
				$section_fields[] = array(
				'type' => 'sectionend' ,
				'id'   => 'efw_order_total_fee_settings' ,
				) ;
				$section_fields[] = array(
				'type'      => 'efw_custom_fields' ,
				'efw_field' => 'section_end' ,
				) ;

				return $section_fields ;
	}

	/**
	 * Validate Settings Before Save.
	 */
	public static function validate_before_save( $bool ) {
		if ( isset( $_REQUEST[ 'efw_ordertotalfee_enable' ] ) && isset( $_REQUEST[ 'efw_ordertotalfee_fee_text' ] ) && isset( $_REQUEST[ 'efw_ordertotalfee_fee_type' ] ) ) {
			if ( empty( $_REQUEST[ 'efw_ordertotalfee_fee_text' ] ) ) {
				EFW_Settings::add_error( esc_html__( 'Fee Text field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
				$bool = false ;
			}

			if ( '1' == $_REQUEST[ 'efw_ordertotalfee_fee_type' ] ) {
				if ( isset( $_REQUEST[ 'efw_ordertotalfee_fixed_value' ] ) && empty( $_REQUEST[ 'efw_ordertotalfee_fixed_value' ] ) ) {
					EFW_Settings::add_error( esc_html__( 'Fixed Fee Value field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
					$bool = false ;
				}
			}

			if ( '2' == $_REQUEST[ 'efw_ordertotalfee_fee_type' ] ) {
				if ( isset( $_REQUEST[ 'efw_ordertotalfee_cart_subtotal_percentage' ] ) && empty( $_REQUEST[ 'efw_ordertotalfee_cart_subtotal_percentage' ] ) ) {
					EFW_Settings::add_error( esc_html__( 'Fee Value in Percent field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
					$bool = false ;
				}
			}

			if ( isset( $_REQUEST[ 'efw_ordertotalfee_min_sub_total' ] ) && empty( $_REQUEST[ 'efw_ordertotalfee_min_sub_total' ] ) ) {
				EFW_Settings::add_error( esc_html__( 'Minimum Cart Subtotal to Add Fee field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
				$bool = false ;
			}

			if ( isset( $_REQUEST[ 'efw_ordertotalfee_max_sub_total' ] ) && empty( $_REQUEST[ 'efw_ordertotalfee_max_sub_total' ] ) ) {
				EFW_Settings::add_error( esc_html__( 'Maximum Cart Subtotal to Add Fee field cannot be empty' , 'extra-fees-for-woocommerce' ) ) ;
				$bool = false ;
			}
		}

		return $bool ;
	}

}

return new EFW_Order_Total_Fee_Tab() ;
