<?php

/**
 * Admin Ajax.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'EFW_Admin_Ajax' ) ) {

	/**
	 * EFW_Admin_Ajax Class.
	 */
	class EFW_Admin_Ajax {

		/**
		 * EFW_Admin_Ajax Class initialization.
		 */
		public static function init() {

			$actions = array(
				'product_search'   => false ,
				'customers_search' => false ,
				'fee_data'         => false ,
					) ;

			foreach ( $actions as $action => $nopriv ) {
				add_action( 'wp_ajax_efw_' . $action , array( __CLASS__ , $action ) ) ;

				if ( $nopriv ) {
					add_action( 'wp_ajax_nopriv_efw_' . $action , array( __CLASS__ , $action ) ) ;
				}
			}
		}

		/**
		 * Product search.
		 */
		public static function product_search() {
			check_ajax_referer( 'efw-search-nonce' , 'efw_security' ) ;

			try {
				$term = isset( $_GET[ 'term' ] ) ? ( string ) wc_clean( wp_unslash( $_GET[ 'term' ] ) ) : '' ;

				if ( empty( $term ) ) {
					throw new exception( esc_html__( 'No Product(s) found' , 'extra-fees-for-woocommerce' ) ) ;
				}

				$data_store = WC_Data_Store::load( 'product' ) ;
				$ids        = $data_store->search_products( $term , '' , true , false , 30 ) ;

				$product_objects = array_filter( array_map( 'wc_get_product' , $ids ) , 'wc_products_array_filter_readable' ) ;
				$products        = array() ;

				$exclude_global_variable = isset( $_GET[ 'exclude_global_variable' ] ) ? wc_clean( wp_unslash( $_GET[ 'exclude_global_variable' ] ) ) : 'no' ; // @codingStandardsIgnoreLine.
				foreach ( $product_objects as $product_object ) {
					if ( 'yes' == $exclude_global_variable && $product_object->is_type( 'variable' ) ) {
						continue ;
					}

					$products[ $product_object->get_id() ] = rawurldecode( $product_object->get_formatted_name() ) ;
				}
				wp_send_json( $products ) ;
			} catch ( Exception $ex ) {
				wp_die() ;
			}
		}

		/**
		 * Customer search.
		 */
		public static function customers_search() {
			check_ajax_referer( 'efw-search-nonce' , 'efw_security' ) ;

			try {
				$term = isset( $_GET[ 'term' ] ) ? ( string ) wc_clean( wp_unslash( $_GET[ 'term' ] ) ) : '' ;

				if ( empty( $term ) ) {
					throw new exception( esc_html__( 'No Customer(s) found' , 'extra-fees-for-woocommerce' ) ) ;
				}

				$exclude = isset( $_GET[ 'exclude' ] ) ? ( string ) wc_clean( wp_unslash( $_GET[ 'exclude' ] ) ) : '' ;
				$exclude = ! empty( $exclude ) ? array_map( 'intval' , explode( ',' , $exclude ) ) : array() ;

				$found_customers = array() ;

				$customers_query = new WP_User_Query( array(
					'fields'         => 'all' ,
					'orderby'        => 'display_name' ,
					'search'         => '*' . $term . '*' ,
					'search_columns' => array( 'ID' , 'user_login' , 'user_email' , 'user_nicename' )
						) ) ;

				$customers = $customers_query->get_results() ;

				if ( efw_check_is_array( $customers ) ) {
					foreach ( $customers as $customer ) {
						if ( ! in_array( $customer->ID , $exclude ) ) {
							$found_customers[ $customer->ID ] = $customer->display_name . ' (#' . $customer->ID . ' &ndash; ' . sanitize_email( $customer->user_email ) . ')' ;
						}
					}
				}

				wp_send_json( $found_customers ) ;
			} catch ( Exception $ex ) {
				wp_die() ;
			}
		}

		/**
		 * Fee Data.
		 */
		public static function fee_data() {
			check_ajax_referer( 'efw-update-fee-data-nonce' , 'efw_security' ) ;

			try {
				$duration_type = isset( $_REQUEST[ 'duration_type' ] ) ? wc_clean( wp_unslash( $_REQUEST[ 'duration_type' ] ) ) : '' ;

				ob_start() ;

				global $wpdb ;

				if ( 'this_week' == $duration_type ) {
					$day        = date_i18n( 'w' ) ;
					$start_date = date_i18n( 'Y-m-d' , strtotime( '-' . $day . ' days' ) ) ;
					$end_date   = date_i18n( 'Y-m-d' , strtotime( '+' . ( 6 - $day ) . ' days' ) ) ;
				} elseif ( 'last_week' == $duration_type ) {
					$previous_week = strtotime( '-1 week +1 day' ) ;

					$start_week = strtotime( 'last sunday midnight' , $previous_week ) ;
					$end_week   = strtotime( 'next saturday' , $start_week ) ;

					$start_date = date_i18n( 'Y-m-d' , $start_week ) ;
					$end_date   = date_i18n( 'Y-m-d' , $end_week ) ;
				} elseif ( 'this_month' == $duration_type ) {
					$start_date = date_i18n( 'Y-m-01' ) ;
					$end_date   = date_i18n( 'Y-m-t' ) ;
				} elseif ( 'last_month' == $duration_type ) {
					$start_date = date_i18n( 'Y-m-d' , strtotime( 'first day of previous month' ) ) ;
					$end_date   = date_i18n( 'Y-m-d' , strtotime( 'last day of previous month' ) ) ;
				}

				if ( 'all' == $duration_type ) {
					$order_fee_query   = $wpdb->get_results( $wpdb->prepare( "SELECT SUM(pm.meta_value) as orderfee FROM {$wpdb->posts} AS p , {$wpdb->postmeta} AS pm where p.post_type=%s and p.post_status IN('publish') and pm.meta_key='efw_order_fee' and p.ID=pm.post_id" , EFW_Register_Post_Type::FEES_POSTTYPE ) , ARRAY_A ) ;
					$product_fee_query = $wpdb->get_results( $wpdb->prepare( "SELECT SUM(pm.meta_value) as productfee FROM {$wpdb->posts} AS p , {$wpdb->postmeta} AS pm where p.post_type=%s and p.post_status IN('publish') and pm.meta_key='efw_product_fee' and p.ID=pm.post_id" , EFW_Register_Post_Type::FEES_POSTTYPE ) , ARRAY_A ) ;
					$gateway_fee_query = $wpdb->get_results( $wpdb->prepare( "SELECT SUM(pm.meta_value) as gatewayfee FROM {$wpdb->posts} AS p , {$wpdb->postmeta} AS pm where p.post_type=%s and p.post_status IN('publish') and pm.meta_key='efw_gateway_fee' and p.ID=pm.post_id" , EFW_Register_Post_Type::FEES_POSTTYPE ) , ARRAY_A ) ;
				} else {
					$order_fee_query   = $wpdb->get_results( $wpdb->prepare( "SELECT SUM(pm.meta_value) as orderfee FROM {$wpdb->posts} AS p , {$wpdb->postmeta} AS pm where p.post_type=%s and p.post_status IN('publish') and pm.meta_key='efw_order_fee' and p.ID=pm.post_id and p.post_date_gmt >= %s and p.post_date_gmt <= %s" , EFW_Register_Post_Type::FEES_POSTTYPE , $start_date , $end_date ) , ARRAY_A ) ;
					$product_fee_query = $wpdb->get_results( $wpdb->prepare( "SELECT SUM(pm.meta_value) as productfee FROM {$wpdb->posts} AS p , {$wpdb->postmeta} AS pm where p.post_type=%s and p.post_status IN('publish') and pm.meta_key='efw_product_fee' and p.ID=pm.post_id and p.post_date_gmt >= %s and p.post_date_gmt <= %s" , EFW_Register_Post_Type::FEES_POSTTYPE , $start_date , $end_date ) , ARRAY_A ) ;
					$gateway_fee_query = $wpdb->get_results( $wpdb->prepare( "SELECT SUM(pm.meta_value) as gatewayfee FROM {$wpdb->posts} AS p , {$wpdb->postmeta} AS pm where p.post_type=%s and p.post_status IN('publish') and pm.meta_key='efw_gateway_fee' and p.ID=pm.post_id and p.post_date_gmt >= %s and p.post_date_gmt <= %s" , EFW_Register_Post_Type::FEES_POSTTYPE , $start_date , $end_date ) , ARRAY_A ) ;
				}

				$order_fee         = end( $order_fee_query ) ;
				$product_fee       = end( $product_fee_query ) ;
				$gateway_fee       = end( $gateway_fee_query ) ;
				$order_fee_value   = efw_check_is_array( $order_fee ) ? $order_fee[ 'orderfee' ] : 0 ;
				$product_fee_value = efw_check_is_array( $product_fee ) ? $product_fee[ 'productfee' ] : 0 ;
				$gateway_fee_value = efw_check_is_array( $gateway_fee ) ? $gateway_fee[ 'gatewayfee' ] : 0 ;
				$total_fee         = $order_fee_value + $product_fee_value + $gateway_fee_value ;

				include_once(EFW_ABSPATH . 'inc/admin/menu/views/reports/reports-data.php') ;

				$html = ob_get_contents() ;
				ob_end_clean() ;

				wp_send_json_success( array( 'html' => $html ) ) ;
			} catch ( Exception $ex ) {
				wp_die() ;
			}
		}

	}

	EFW_Admin_Ajax::init() ;
}
