<?php

/**
* Plugin Name: Extra Fees for WooCommerce
* Description: You can charge an extra fee for your orders based on Product Price, Payment Gateway & Amount spent in the order on your WooCommerce Shop.
* Version: 2.2
* Author: FantasticPlugins
* Author URI: http://fantasticplugins.com
* Text Domain: extra-fees-for-woocommerce
* Domain Path: /languages
* Woo: 6036731:cc3a0e0a5993504d839eee17714e6d57
* Tested up to: 5.8.1
* WC tested up to: 5.8.0
* WC requires at least: 3.7.0
* Copyright: © 2020 FantasticPlugins
* License: GNU General Public License v3.0
* License URI: http://www.gnu.org/licenses/gpl-3.0.html
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

/* Include once will help to avoid fatal error by load the files when you call init hook */
require_once ABSPATH . 'wp-admin/includes/plugin.php' ;

/**
 * Function to check whether WooCommerce is active or not.
 */
function efw_maybe_woocommerce_active() {

	if ( is_multisite() ) {
		// This Condition is for Multi Site WooCommerce Installation
		if ( ! is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) && ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) ) {
			if ( is_admin() ) {
				add_action( 'init' , 'efw_display_warning_message' ) ;
			}
			return false ;
		}
	} else {
		// This Condition is for Single Site WooCommerce Installation
		if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			if ( is_admin() ) {
				add_action( 'init' , 'efw_display_warning_message' ) ;
			}
			return false ;
		}
	}
	return true ;
}

/**
 * Display Warning message.
 */
function efw_display_warning_message() {
	echo "<div class='error'><p> Extra Fees for WooCommerce Plugin will not work until WooCommerce Plugin is Activated. Please Activate the WooCommerce Plugin. </p></div>" ;
}

//Retrun if WooCommerce is not active.
if ( ! efw_maybe_woocommerce_active() ) {
	return ;
}

//Define constant.
if ( ! defined( 'EFW_PLUGIN_FILE' ) ) {
	define( 'EFW_PLUGIN_FILE' , __FILE__ ) ;
}

// Include main class file.
if ( ! class_exists( 'EFW' ) ) {
	include_once 'inc/class-extra-fees.php' ;
}

// Return Extra Fees For WooCommerce class object.
if ( ! function_exists( 'EFW' ) ) {

	function EFW() {
		return EFW::instance() ;
	}

}

// Initialize the plugin.
EFW() ;
