jQuery( function ( $ ) {

    var EFW_Frontend_Scripts = {
        init : function ( ) {
            EFW_Frontend_Scripts.add_fee_for_gateway() ;
            $( '#order_review' ).on( 'change' , 'input[name="payment_method"]' , this.add_fee_for_gateway ) ;
            $( document ).on( 'change' , 'input, wcva_attribute_radio' , this.variation_notice ) ;
        } ,
        add_fee_for_gateway : function () {
            if ( efw_frontend_param.is_checkout ) {
                EFW_Frontend_Scripts.block( '#order_review' ) ;
                var gatewayid = $( '.payment_methods input[name="payment_method"]:checked' ).val() ;
                var data = ( {
                    action : 'efw_add_fee' ,
                    gatewayid : gatewayid ,
                    efw_security : efw_frontend_param.fee_nonce
                } ) ;
                $.post( efw_frontend_param.ajaxurl , data , function ( response ) {
                    if ( true === response.success ) {
                        $( 'body' ).trigger( 'update_checkout' ) ;
                    } else {
                        window.alert( response.data.error ) ;
                    }
                    EFW_Frontend_Scripts.unblock( '#order_review' ) ;
                } ) ;
            }
        } ,
        variation_notice : function ( ) {
            if ( efw_frontend_param.is_product && 'yes' == efw_frontend_param.is_enabled) {
                if ( $( this ).closest( 'div.single_variation_wrap' ).find( 'input:hidden[name=variation_id], input.variation_id' ).length ) {
                    var variationid = $( this ).closest( 'div.single_variation_wrap' ).find( 'input:hidden[name=variation_id], input.variation_id' ).val() ;
                    if ( variationid === '' || variationid === 0 || variationid === undefined ) {
                        return false ;
                    } else {
                        EFW_Frontend_Scripts.block( $( this ) ) ;
                        var data = ( {
                            action : 'efw_variation_notice' ,
                            variationid : variationid ,
                            efw_security : efw_frontend_param.fee_nonce
                        } ) ;
                        $.post( efw_frontend_param.ajaxurl , data , function ( response ) {
                            if ( true === response.success ) {
                                $( '.woocommerce-variation-price' ).html( response.data.html ) ;
                            } else {
                                window.alert( response.data.error ) ;
                            }
                            EFW_Frontend_Scripts.unblock( $( this ) ) ;
                        } ) ;
                    }
                }
            }
        } ,
        block : function ( id ) {
            $( id ).block( {
                message : null ,
                overlayCSS : {
                    background : '#fff' ,
                    opacity : 0.6
                }
            } ) ;
        } ,
        unblock : function ( id ) {
            $( id ).unblock() ;
        } ,
    } ;
    EFW_Frontend_Scripts.init( ) ;
} ) ;
