jQuery( function ( $ ) {

    var EFW_Bulk_Update = {
        init : function ( ) {

            $( document ).on( 'click' , '#efw_productfee_bulk_update' , this.update_fee ) ;

            //Display Upgrade percentage
            this.diplay_upgrade_percentage() ;
        } ,
        diplay_upgrade_percentage : function () {

            if ( ! $( 'div.efw_prograss_bar_wrapper' ).length )
                return ;

            var data = {
                action : 'efw_background_process_count' ,
                efw_security : efw_bulk_update_param.bulk_update_nonce
            } ;
            $.ajax( {
                type : 'POST' ,
                url : ajaxurl ,
                data : data ,
                dataType : 'json' ,
            } ).done( function ( res ) {
                if ( true === res.success ) {
                    if ( res.data.completed === 'no' ) {
                        $( '#efw_prograss_bar_current_status' ).html( res.data.percentage ) ;
                        $( '.efw_prograss_bar_inner' ).css( "width" , res.data.percentage + "%" ) ;
                        EFW_Bulk_Update.diplay_upgrade_percentage() ;
                    } else {
                        $( '#efw_prograss_bar_label' ).css( "display" , "none" ) ;
                        $( '.efw_prograss_bar_inner' ).css( "width" , "100%" ) ;
                        $( '#efw_prograss_bar_status' ).html( res.data.msg ) ;
                        window.location.href = res.data.redirect_url ;
                    }
                }
            } ) ;
        } ,
        update_fee : function ( event ) {
            event.preventDefault( ) ;
            EFW_Bulk_Update.block( '#efw_productfee_bulk_update' ) ;
            var enable_fee = $( '#efw_productfee_bulk_enable' ).is( ':checked' ) ? 'yes' : 'no' ;
            var text_from = $( '#efw_productfee_bulk_text_from ' ).val() ;
            var fee_text = $( '#efw_productfee_bulk_fee_text ' ).val() ;
            var fee_type = $( '#efw_productfee_bulk_fee_type ' ).val() ;
            var fixed_value = $( '#efw_productfee_bulk_fixed_value ' ).val() ;
            var percent_value = $( '#efw_productfee_bulk_percent_value ' ).val() ;
            if ( 'yes' == enable_fee ) {
                if ( '2' == text_from ) {
                    if ( '' == fee_text ) {
                        alert( 'Fee Text cannot be empty' ) ;
                        return ;
                    }
                }

                if ( '1' == fee_type ) {
                    if ( '' == fixed_value ) {
                        alert( 'Fixed Fee Value cannot be empty' ) ;
                        return ;
                    }
                } else {
                    if ( '' == percent_value ) {
                        alert( 'Percentage Fee Value cannot be empty' ) ;
                        return ;
                    }
                }
            }

            var data = {
                action : 'efw_update_fee' ,
                product_filter : $( '#efw_productfee_product_filters' ).val() ,
                inc_products : $( '#efw_productfee_update_inc_products' ).val() ,
                exc_products : $( '#efw_productfee_update_exc_products' ).val() ,
                inc_category : $( '#efw_productfee_update_inc_category' ).val() ,
                exc_category : $( '#efw_productfee_update_exc_category' ).val() ,
                enable_fee : enable_fee ,
                text_from : text_from ,
                fee_text : fee_text ,
                fee_type : fee_type ,
                fixed_value : fixed_value ,
                percent_value : percent_value ,
                efw_security : efw_bulk_update_param.bulk_update_nonce
            } ;
            $.post( efw_bulk_update_param.ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    window.location.href = response.data.redirect_url ;
                } else {
                    window.alert( response.data.error ) ;
                }
                EFW_Bulk_Update.unblock( '#efw_productfee_bulk_update' ) ;
            } ) ;
        } ,
        block : function ( id ) {
            $( id ).block( {
                message : null ,
                overlayCSS : {
                    background : '#fff' ,
                    opacity : 0.6
                }
            } ) ;
        } ,
        unblock : function ( id ) {
            $( id ).unblock() ;
        } ,
    } ;
    EFW_Bulk_Update.init( ) ;
} ) ;
