jQuery( function ( $ ) {

    var EFW_Toggle = {
        init : function ( ) {
            this.trigger_on_page_load() ;

            $( document ).on( 'change' , '#efw_productfee_enable' , this.enable_product_fee ) ;
            $( document ).on( 'change' , '.efw_enable_fee' , this.enable_extra_fee ) ;
            $( document ).on( 'change' , '.efw-enable-gateway-fee' , this.enable_gateway_fee ) ;
            $( document ).on( 'change' , '#efw_ordertotalfee_enable' , this.enable_ordertotal_fee ) ;

            $( document ).on( 'change' , '.efw_productfee_fee_setup' , this.fee_based_on ) ;
            $( document ).on( 'change' , '#efw_productfee_apply_for' , this.apply_for ) ;
            $( document ).on( 'change' , '#efw_productfee_product_filters' , this.product_filter_type ) ;

            $( document ).on( 'change' , '#efw_productfee_fee_type' , this.product_fee_type ) ;
            $( document ).on( 'change' , '.efw_extra_fee_type' , this.extra_fee_type ) ;
            $( document ).on( 'change' , '.efw_text_from' , this.fee_text_from ) ;
            $( document ).on( 'change' , '.efw-fee-type' , this.gateway_fee_type ) ;
            $( document ).on( 'change' , '#efw_productfee_user_filter' , this.user_filter_for_product ) ;
            $( document ).on( 'change' , '.efw-user-filter-type' , this.user_filter_for_gateway ) ;
            $( document ).on( 'change' , '.efw-product-filter-type' , this.product_filter_for_gateway ) ;
            $( document ).on( 'change' , '#efw_ordertotalfee_fee_type' , this.order_total_fee_type ) ;
            $( document ).on( 'change' , '#efw_ordertotalfee_user_filter' , this.user_filter_for_order ) ;

            $( document ).on( 'change' , '#efw_productfee_bulk_enable' , this.bulk_update_products ) ;
            $( document ).on( 'change' , '#efw_productfee_bulk_text_from' , this.bulk_update_fee_text_from ) ;
            $( document ).on( 'change' , '#efw_productfee_bulk_fee_type' , this.bulk_update_fee_type ) ;
            
            $( document ).on( 'click' , '.efw-view-report' , this.get_update_fee_data ) ;
        } ,

        trigger_on_page_load : function () {
            EFW_Toggle.toggle_enable_product_fee( '#efw_productfee_enable' ) ;

            $( '.efw-enable-gateway-fee' ).each( function () {
                EFW_Toggle.toggle_enable_gateway_fee( $( this ) ) ;
            } ) ;

            EFW_Toggle.toggle_enable_ordertotal_fee( '#efw_ordertotalfee_enable' ) ;

            EFW_Toggle.toggle_enable_extra_fee( '.efw_enable_fee' ) ;

            $( '#woocommerce-product-data' ).on( 'woocommerce_variations_loaded' , function ( evt ) {
                $( '.efw_enable_fee' ).each( function () {
                    EFW_Toggle.toggle_enable_extra_fee( $( this ) ) ;
                } ) ;
            } ) ;
        } ,
        enable_product_fee : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_enable_product_fee( $this ) ;
        } ,
        toggle_enable_product_fee : function ( $this ) {
            if ( true == $( $this ).is( ':checked' ) ) {
                $( '.show-if-product-fee-enable' ).closest( 'tr' ).show() ;
                EFW_Toggle.toggle_fee_based_on( '.efw_productfee_fee_setup:checked' ) ;
                EFW_Toggle.toggle_user_filter_for_product( '#efw_productfee_user_filter' ) ;
            } else {
                $( '.show-if-product-fee-enable' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_apply_for' ).closest( '.form-table' ).next().hide() ;
            }
        } ,
        enable_extra_fee : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_enable_extra_fee( $this ) ;
        } ,
        toggle_enable_extra_fee : function ( $this ) {
            if ( true == $( $this ).is( ':checked' ) ) {
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-show-if-extra-fee-enable' ).show() ;
                EFW_Toggle.toggle_fee_text_from( '.efw_text_from' ) ;
                EFW_Toggle.toggle_extra_fee_type( $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw_extra_fee_type' ) ) ;
            } else {
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-show-if-extra-fee-enable' ).hide() ;
            }
        } ,
        extra_fee_type : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_extra_fee_type( $this ) ;
        } ,
        toggle_extra_fee_type : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-fixed-type' ).show() ;
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-percent-type' ).hide() ;
            } else {
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-fixed-type' ).hide() ;
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-percent-type' ).show() ;
            }
        } ,
        fee_text_from : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_fee_text_from( $this ) ;
        } ,
        toggle_fee_text_from : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-extra-fee-text' ).hide() ;
            } else {
                $( $this ).closest( '.efw-fee-wrapper' ).find( '.efw-extra-fee-text' ).show() ;
            }
        } ,
        enable_gateway_fee : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_enable_gateway_fee( $this ) ;
        } ,
        toggle_enable_gateway_fee : function ( $this ) {
            if ( true == $( $this ).is( ':checked' ) ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-show-if-enable' ).show() ;
                EFW_Toggle.toggle_gateway_fee_type( $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-fee-type' ) ) ;
                EFW_Toggle.toggle_user_filter_for_gateway( $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-user-filter-type' ) ) ;
                EFW_Toggle.toggle_product_filter_for_gateway( $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-product-filter-type' ) ) ;
            } else {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-show-if-enable' ).hide() ;
            }
        } ,
        enable_ordertotal_fee : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_enable_ordertotal_fee( $this ) ;
        } ,
        toggle_enable_ordertotal_fee : function ( $this ) {
            if ( true == $( $this ).is( ':checked' ) ) {
                $( '.show-if-order-fee-enable' ).closest( 'tr' ).show() ;
                EFW_Toggle.toggle_order_total_fee_type( '#efw_ordertotalfee_fee_type' ) ;
                EFW_Toggle.toggle_user_filter_for_order( '#efw_ordertotalfee_user_filter' ) ;
            } else {
                $( '.show-if-order-fee-enable' ).closest( 'tr' ).hide() ;
            }
        } ,
        fee_based_on : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_fee_based_on( $this ) ;
        } ,
        toggle_fee_based_on : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_productfee_apply_for' ).closest( 'tr' ).show() ;
                EFW_Toggle.toggle_apply_for( '#efw_productfee_apply_for' ) ;
                $( '#efw_productfee_fee_type' ).closest( 'tr' ).show() ;
                EFW_Toggle.toggle_product_fee_type( '#efw_productfee_fee_type' ) ;
                $( '#efw_productfee_product_filters' ).closest( '.form-table' ).hide() ;
                $( '#efw_productfee_apply_for' ).closest( '.form-table' ).next().hide() ;
            } else {
                $( '#efw_productfee_apply_for' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_fee_type' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_percent_value' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_fixed_value' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_product_filters' ).closest( '.form-table' ).show() ;
                $( '#efw_productfee_apply_for' ).closest( '.form-table' ).next().show() ;
                EFW_Toggle.toggle_product_filter_type( '#efw_productfee_product_filters' ) ;
                $( '#efw_productfee_bulk_enable' ).closest( 'tr' ).show() ;
                EFW_Toggle.toggle_bulk_update_products( '#efw_productfee_bulk_enable' ) ;
            }
        } ,
        bulk_update_products : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_bulk_update_products( $this ) ;
        } ,
        toggle_bulk_update_products : function ( $this ) {
            if ( $( $this ).is( ':checked' ) ) {
                $( '#efw_productfee_bulk_text_from' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_bulk_fee_type' ).closest( 'tr' ).show() ;
                EFW_Toggle.toggle_bulk_update_fee_text_from( '#efw_productfee_bulk_text_from' ) ;
                EFW_Toggle.toggle_bulk_update_fee_type( '#efw_productfee_bulk_fee_type' ) ;
            } else {
                $( '#efw_productfee_bulk_text_from' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_bulk_fee_text' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_bulk_fee_type' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_bulk_fixed_value' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_bulk_percent_value' ).closest( 'tr' ).hide() ;
            }
        } ,
        bulk_update_fee_text_from : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_bulk_update_fee_text_from( $this ) ;
        } ,
        toggle_bulk_update_fee_text_from : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_productfee_bulk_fee_text' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_productfee_bulk_fee_text' ).closest( 'tr' ).show() ;
            }
        } ,
        bulk_update_fee_type : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_bulk_update_fee_type( $this ) ;
        } ,
        toggle_bulk_update_fee_type : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_productfee_bulk_fixed_value' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_bulk_percent_value' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_productfee_bulk_fixed_value' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_bulk_percent_value' ).closest( 'tr' ).show() ;
            }
        } ,
        product_filter_type : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_product_filter_type( $this ) ;
        } ,
        toggle_product_filter_type : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_productfee_update_inc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_inc_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_category' ).closest( 'tr' ).hide() ;
            } else if ( '2' == $( $this ).val() ) {
                $( '#efw_productfee_update_inc_products' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_update_exc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_inc_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_category' ).closest( 'tr' ).hide() ;
            } else if ( '3' == $( $this ).val() ) {
                $( '#efw_productfee_update_inc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_products' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_update_inc_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_category' ).closest( 'tr' ).hide() ;
            } else if ( '4' == $( $this ).val() ) {
                $( '#efw_productfee_update_inc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_inc_category' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_update_exc_category' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_productfee_update_inc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_inc_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_update_exc_category' ).closest( 'tr' ).show() ;
            }
        } ,
        apply_for : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_apply_for( $this ) ;
        } ,
        toggle_apply_for : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_productfee_include_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_category' ).closest( 'tr' ).hide() ;
            } else if ( '2' == $( $this ).val() ) {
                $( '#efw_productfee_include_products' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_exclude_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_category' ).closest( 'tr' ).hide() ;
            } else if ( '3' == $( $this ).val() ) {
                $( '#efw_productfee_include_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_products' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_include_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_category' ).closest( 'tr' ).hide() ;
            } else if ( '4' == $( $this ).val() ) {
                $( '#efw_productfee_include_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_category' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_exclude_category' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_productfee_include_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_products' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_category' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_category' ).closest( 'tr' ).show() ;
            }
        } ,
        product_fee_type : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_product_fee_type( $this ) ;
        } ,
        toggle_product_fee_type : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_productfee_fixed_value' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_percent_value' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_productfee_fixed_value' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_percent_value' ).closest( 'tr' ).show() ;
            }
        } ,
        user_filter_for_product : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_user_filter_for_product( $this ) ;
        } ,
        toggle_user_filter_for_product : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_productfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else if ( '2' == $( $this ).val() ) {
                $( '#efw_productfee_include_users' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else if ( '3' == $( $this ).val() ) {
                $( '#efw_productfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_users' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else if ( '4' == $( $this ).val() ) {
                $( '#efw_productfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_userrole' ).closest( 'tr' ).show() ;
                $( '#efw_productfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_productfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_productfee_exclude_userrole' ).closest( 'tr' ).show() ;
            }
        } ,
        gateway_fee_type : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_gateway_fee_type( $this ) ;
        } ,
        toggle_gateway_fee_type : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-fixed-fee' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-percentage-type' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-percent-cart-subtotal' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-minimum-fee' ).hide() ;
            } else if ( '2' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-fixed-fee' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-percentage-type' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-percent-cart-subtotal' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-minimum-fee' ).show() ;
            } else {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-fixed-fee' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-percentage-type' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-percent-cart-subtotal' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-minimum-fee' ).show() ;
            }
        } ,
        user_filter_for_gateway : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_user_filter_for_gateway( $this ) ;
        } ,
        toggle_user_filter_for_gateway : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user-role' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user-role' ).hide() ;
            } else if ( '2' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user-role' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user-role' ).hide() ;
            } else if ( '3' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user-role' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user-role' ).hide() ;
            } else if ( '4' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user-role' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user-role' ).hide() ;
            } else {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-user-role' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-user-role' ).show() ;
            }
        } ,
        product_filter_for_gateway : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_product_filter_for_gateway( $this ) ;
        } ,
        toggle_product_filter_for_gateway : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-category' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-category' ).hide() ;
            } else if ( '2' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-product' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-category' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-category' ).hide() ;
            } else if ( '3' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-product' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-category' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-category' ).hide() ;
            } else if ( '4' == $( $this ).val() ) {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-category' ).show() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-category' ).hide() ;
            } else {
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-product' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-include-category' ).hide() ;
                $( $this ).closest( '.efw-gateway-fee-settings' ).find( '.efw-exclude-category' ).show() ;
            }
        } ,
        order_total_fee_type : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_order_total_fee_type( $this ) ;
        } ,
        toggle_order_total_fee_type : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_ordertotalfee_fixed_value' ).closest( 'tr' ).show() ;
                $( '#efw_ordertotalfee_cart_subtotal_percentage' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_ordertotalfee_fixed_value' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_cart_subtotal_percentage' ).closest( 'tr' ).show() ;
            }
        } ,
        user_filter_for_order : function ( event ) {
            event.preventDefault( ) ;
            var $this = $( event.currentTarget ) ;
            EFW_Toggle.toggle_user_filter_for_order( $this ) ;
        } ,
        toggle_user_filter_for_order : function ( $this ) {
            if ( '1' == $( $this ).val() ) {
                $( '#efw_ordertotalfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else if ( '2' == $( $this ).val() ) {
                $( '#efw_ordertotalfee_include_users' ).closest( 'tr' ).show() ;
                $( '#efw_ordertotalfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else if ( '3' == $( $this ).val() ) {
                $( '#efw_ordertotalfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_users' ).closest( 'tr' ).show() ;
                $( '#efw_ordertotalfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else if ( '4' == $( $this ).val() ) {
                $( '#efw_ordertotalfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_include_userrole' ).closest( 'tr' ).show() ;
                $( '#efw_ordertotalfee_exclude_userrole' ).closest( 'tr' ).hide() ;
            } else {
                $( '#efw_ordertotalfee_include_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_users' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_include_userrole' ).closest( 'tr' ).hide() ;
                $( '#efw_ordertotalfee_exclude_userrole' ).closest( 'tr' ).show() ;
            }
        } ,
        get_update_fee_data : function ( event ) {
            event.preventDefault( ) ;
            EFW_Toggle.block( '.efw-reports-wrapper' ) ;
            var data = {
                action : 'efw_fee_data' ,
                duration_type : $( '.efw-duration-type' ).val() ,
                efw_security : efw_admin_param.update_fee_data_nonce
            } ;
            $.post( efw_admin_param.ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    $('.efw-reports-wrapper').html(response.data.html);
                } else {
                    window.alert( response.data.error ) ;
                }
                EFW_Toggle.unblock( '.efw-reports-wrapper' ) ;
            } ) ;
        } ,
        block : function ( id ) {
            $( id ).block( {
                message : null ,
                overlayCSS : {
                    background : '#fff' ,
                    opacity : 0.6
                }
            } ) ;
        } ,
        unblock : function ( id ) {
            $( id ).unblock() ;
        } ,
    } ;
    EFW_Toggle.init( ) ;
} ) ;
