jQuery(function($) {
	
	$('.cmreg-profile-edit-form').submit(function(ev) {
		ev.preventDefault();
		ev.stopPropagation();
		var form = $(this);		

		var formEP = document.getElementById('cmreg-profile-edit-form');
		var formData = new FormData(formEP);

		$.ajax({
			method: 'POST',
			url: form.attr('action'),
			data: formData,
			cache: false,
			contentType: false,
			processData: false,
			success: function(response) {
				window.CMREG.Utils.toast(response.msg);
				if (response.success) {
					if(response.isadmin == 'yes') {
						window.location = window.location.href;
					} else {
						window.location = window.location.href.split("?")[0];
					}
				}
			},
			error: function (err){
				console.log(err);
			}
		});

	});
	
	$('.cmreg-change-password-form').submit(function(ev) {
		ev.preventDefault();
		ev.stopPropagation();
		var form = $(this);
		var data = form.serialize();
		$.post(form.attr('action'), data, function(response) {
			window.CMREG.Utils.toast(response.msg);
			if (response.success) {
				form[0].reset();
			}
		});
	});

	$('.cmreg-reset-password-form').submit(function(ev) {
		ev.preventDefault();
		ev.stopPropagation();
		var form = $(this);
		var data = form.serialize();
		$.post(form.attr('action'), data, function(response) {
			window.CMREG.Utils.toast(response.msg);
			if (response.success) {
				form[0].reset();
			}
		});
	});

	$(document).on('click', '.cmreg-image', function(e) {
		e.preventDefault();
		e.stopPropagation();
		
		var $container = $(this).closest('.cmreg-field-profileimage');
		$container.find('input[name="avatar"]').click();
	});

	$('#cmreg-input-avatar').on('change', function() {
		if ($(this).prop('files') && $(this).prop('files')[0]) {
			var reader = new FileReader();
			reader.onload = function(e) {
				$('#cmreg-img').attr('src', e.target.result);
			}
			reader.readAsDataURL($(this).prop('files')[0]);
		}
	});

	$(document).on('click', '.cmreg-remove-image', function(e) {
		$('#cmreg-img').attr('src', $(this).attr('data-placeholdersrc'));
		$('#cmreg_profile_image_id').val($(this).attr('data-placeholdersrc'));
	});

});