<?php
/**
 * Template to My Account manage the customer checks
 *
 *  Override this template by copying it to yourtheme/woocommerce/myaccount/myaccount-paytrace-saved-checks.php
 *
 * @var string $gateway_id
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<h2 id="paytrace-saved-checks" style="margin-top:40px;"><?php _e( 'Saved Checks', WC_Paytrace::TEXT_DOMAIN ); ?></h2>
<table class="shop_table">
	<thead>
	<tr>
		<th><?php _e( 'Routing Number', WC_Paytrace::TEXT_DOMAIN ); ?></th>
		<th><?php _e( 'Account Number', WC_Paytrace::TEXT_DOMAIN ); ?></th>
		<th></th>
	</tr>
	</thead>
	<tbody>
    <?php
    /**
     * @var WC_Paytrace_Token $check
     */
    foreach ( $saved_checks as $n => $check ) : ?>
		<tr>
			<td>... <?php echo $check->get_routing_last4(); ?></td>
			<td>... <?php echo $check->get_last4(); ?></td>
			<td>
				<form method="post">
					<input type="hidden" name="paytrace_delete_token" value="<?php echo $check->get_id(); ?>" />
					<input type="submit" style="float:left;" class="button" value="<?php _e( 'Delete', WC_Paytrace::TEXT_DOMAIN ); ?>" />
			<?php wp_nonce_field( 'paytrace_delete_token', 'paytrace-nonce' ); ?>
				</form>
				<input type="button"
				       class="button paytrace_update_echeck_toggle"
				       name="paytrace_drop_update"
				       data-echeck-id="<?php echo $check->get_id(); ?>"
				       value="<?php _e( 'Update', WC_Paytrace::TEXT_DOMAIN ); ?>"
				/>

				<div class="clear"></div>
			</td>
		</tr>
		<tr style="display:none" class="update-echeck-<?php echo $check->get_id(); ?>">
			<td colspan="3">
				<div class="update_check_fields_<?php echo $check->get_id(); ?>" style="margin-top: 25px;">
					<form method="post">
			    <?php

			    // Load the checks form template
			    wc_get_template(
				    'checkout/paytrace-checks-form.php',
				    array(
					    'gateway'             => $gateway_id,
					    'gateway_id'          => $gateway_id,
					    'show_name_on_echeck' => true,
				    ),
				    '',
				    \WC_Paytrace::plugin_path() . '/templates/'
			    );
			    ?>
						<input type="hidden" name="paytrace_update_check" value="<?php echo $check->get_id(); ?>" />
						<a data-echeck-id="<?php echo $check->get_id(); ?>" class="button paytrace_update_echeck_toggle">
				<?php _e( 'Close', WC_Paytrace::TEXT_DOMAIN ); ?>
						</a>
						<input id="place_order" class="button alt" type="submit" value="<?php _e( 'Update', WC_Paytrace::TEXT_DOMAIN ); ?>">
			    <?php wp_nonce_field( 'paytrace-update-check', 'paytrace-nonce' ); ?>
					</form>
				</div>
			</td>
		</tr>
    <?php endforeach; ?>

	</tbody>
</table>