<?php
/**
 * Template to My Account manage the customer saved cards
 *
 * Override this template by copying it to yourtheme/woocommerce/myaccount/myaccount-paytrace-saved-cards.php
 *
 * @var WC_Paytrace_Token   $card
 * @var array               $saved_cards
 * @var WC_Paytrace_Gateway $gateway
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<h2 id="paytrace-saved-cards" style="margin-top:40px;"><?php _e( 'Saved Cards', WC_Paytrace::TEXT_DOMAIN ); ?></h2>
<table class="shop_table">
	<thead>
	<tr>
		<th><?php _e( 'Card ending in...', WC_Paytrace::TEXT_DOMAIN ); ?></th>
		<th><?php _e( 'Expires', WC_Paytrace::TEXT_DOMAIN ); ?></th>
		<th></th>
	</tr>
	</thead>
	<tbody>
	<?php foreach ( $saved_cards as $n => $card ) : ?>
		<tr>
			<td><?php echo $card->get_last4(); ?></td>
			<td><?php echo $card->get_expiry_month() . '/' . $card->get_expiry_year() ?></td>
			<td>
				<form method="post">
					<input type="hidden" name="paytrace_delete_token" value="<?php echo $n; ?>" />
					<input type="submit" style="float:left;" class="button" value="<?php _e( 'Delete', WC_Paytrace::TEXT_DOMAIN ); ?>" />
					<?php wp_nonce_field( 'paytrace_delete_token', 'paytrace-nonce' ); ?>
				</form>
				<input type="button"
				       class="button paytrace_update_card_toggle"
				       name="paytrace_drop_update"
				       data-card-id="<?php echo $card->get_id(); ?>"
				       value="<?php _e( 'Update', WC_Paytrace::TEXT_DOMAIN ); ?>" />

				<div class="clear"></div>
			</td>
		</tr>
		<tr style="display:none" class="update-card-<?php echo $card->get_id(); ?>">
			<td colspan="3">
				<div class="paytrace-update-card-form-wrapper update_card_fields_<?php echo $card->get_id(); ?>" style="margin-top: 25px;">
					<form method="post">
						<?php
						// Load the credit card form template
						wc_get_template(
							'checkout/paytrace-payment-form.php',
							array(
								'gateway'            => $gateway->id,
								'gateway_id'         => $gateway->id,
								'save_card_text'     => $gateway->get_option( 'save_card_text' ),
								'show_save_customer' => false,
								'show_cvc'           => false,
								'show_name_on_card'  => true,
								'use_encrypted'      => 'encryption' === $gateway->get_security_type(),
								'security_type'      => $gateway->get_security_type(),
							),
							'',
							\WC_Paytrace::plugin_path() . '/templates/'
						);
						?>
						<input type="hidden" name="paytrace_update_card" value="<?php echo $card->get_id(); ?>" />
						<a data-card-id="<?php echo $card->get_id(); ?>" class="button paytrace_update_card_toggle">
							<?php _e( 'Close', WC_Paytrace::TEXT_DOMAIN ); ?>
						</a>
						<input id="place_order"
						       class="button alt"
						       type="submit"
						       value="<?php _e( 'Update', WC_Paytrace::TEXT_DOMAIN ); ?>" />
						<?php wp_nonce_field( 'paytrace-update-card', 'paytrace-nonce' ); ?>
					</form>
				</div>
			</td>
		</tr>
	<?php endforeach; ?>

	</tbody>
</table>