<?php
/**
 * Separate payment fields for the Checks and Cards
 *
 * @since    2.4.0
 * @version  2.4.0
 * @author   VanboDevelops
 * @var WC_Paytrace_Gateway      $gateway
 * @var WC_Paytrace_Payment_Form $form
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
	<style type="text/css">
		/* form specific css. Not in file */
		.methods .wc_payment_method.payment_method_paytrace,
		.woocommerce-PaymentMethods .payment_method_paytrace {
			display: none;
		}

		.payment_box_paytrace_card,
		.payment_box_paytrace_check {
			display: none;
		}
	</style>
<?php

foreach ( $form->get_sections_data() as $section ) {
	?>

	</div></li>
<li class="wc_payment_method separated_section_<?php echo esc_attr( $form->get_gateway()->id ); ?> payment_method_<?php echo esc_attr( $section['slug'] ); ?>_<?php echo esc_attr( $form->get_gateway()->id ); ?>">
	<input
		id="payment_method_<?php echo esc_attr( $section['slug'] ); ?>_<?php echo esc_attr( $form->get_gateway()->id ); ?>"
		type="radio"
		class="input-radio"
		value="<?php echo esc_attr( $section['slug'] ); ?>"
		name="<?php echo esc_attr( $form->get_gateway()->id ); ?>_type_choice"
		data-order_button_text="<?php echo esc_attr( $section['label'] ); ?>">
	<label for="payment_method_<?php echo esc_attr( $section['slug'] ); ?>_<?php echo esc_attr( $form->get_gateway()->id ); ?>">
		<?php
		echo $section['label'];
		echo $form->get_gateway()->get_payment_type_images( $section['slug'] );
		?>
	</label>
<div class="woocommerce-PaymentBox payment_box payment_box_paytrace payment_box_paytrace_<?php echo esc_attr( $section['slug'] ); ?>" style="display: block;">
	
	<?php
	if ( $section['description'] ) {
		echo wpautop( wptexturize( $section['description'] ) );
	}
	
	if ( 'check' == $section['slug'] ) {
		$form->maybe_output_checks_form();
	} else {
		$form->output_cards_form();
	}
	?>

<?php }