<?php
/**
 * PhpStorm
 *
 * @since  2.4.0
 * @author VanboDevelops
 * @var string                   $gateway_id         The gateway ID
 * @var string                   $save_method_text   The text chosen for the save cards prompt
 * @var bool                     $show_save_customer Should we show the customer save card prompt
 * @var WC_Paytrace_Payment_Form $form
 * @var string                   $type
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="<?php echo $form->get_gateway()->separated_forms ? 'create-account' : ''; ?> <?php echo esc_attr( $gateway_id ) ?>-create-account <?php echo esc_attr( $type ); ?>">
	<p class="form-row form-row-wide">
		<input id="<?php echo esc_attr( $gateway_id ) ?>-save-<?php echo esc_attr( $type ); ?>"
		       style="width:auto;"
		       checked="checked"
		       class="paytrace_save_<?php echo esc_attr( $type ); ?>"
		       value="1"
		       type="checkbox"
		       name="<?php echo esc_attr( $gateway_id ) ?>-save-<?php echo esc_attr( $type ); ?>"
		/>
		<label for="<?php echo esc_attr( $gateway_id ) ?>-save-<?php echo esc_attr( $type ); ?>" style="display:inline;">
			<?php echo wp_kses( $save_method_text,
				array(
					'a' => array(
						'href'  => array(),
						'title' => array(),
					),
				) ); ?>
			<span class="required">*</span>
		</label>
	</p>
</div>