<?php

namespace WcPaytrace\Integrations\Settings;

use WcPaytrace\Abstracts\Integration;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since
 * @author VanboDevelops
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Commons extends Integration {
	
	public $type;
	
	public function __construct( $gateway ) {
		parent::__construct( $gateway );
		
		$this->type = $this->get_gateway()->get_option( 'integration' );
	}
	
	public function credentials() {
		return array(
			$this->type . '_credentials_settings_start' => array(
				'title'       => __( 'Credentials', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'title',
				'class'       => 'integration_' . $this->type,
				'description' => '',
			),
			
			'user_name' => array(
				'title'       => __( 'PayTrace User Name', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'text',
				'description' => __( 'Your PayTrace user name is required to authenticate your request.', \WC_Paytrace::TEXT_DOMAIN ),
				'default'     => '',
				'desc_tip'    => true,
				'class'       => 'integration_' . $this->type,
			),
			
			'password' => array(
				'title'       => __( 'PayTrace Password', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'password',
				'description' => __(
					'Your PayTrace password is required to authenticate your request.
                                        The Password field will always appear empty. Just enter the password,
                                        when you want to set it. Leave empty otherwise.', \WC_Paytrace::TEXT_DOMAIN
				),
				'placeholder' => 'API Password',
				'default'     => '',
				'desc_tip'    => true,
				'class'       => 'integration_' . $this->type,
			),
			
			$this->type . '_credentials_settings_end' => array(
				'title'       => '<hr/>',
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_' . $this->type,
			),
		);
	}
	
	public function display_form() {
		return array(
			$this->type . '_display_settings_start' => array(
				'title'       => __( 'Form Display Settings', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'title',
				'class'       => 'integration_' . $this->type,
				'description' => '',
			),
			
			'separated_forms' => array(
				'title'       => __( 'Payment Forms Display', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'select',
				'options'     => array(
					'together' => __( 'Together', \WC_Paytrace::TEXT_DOMAIN ),
					'separate' => __( 'Separate', \WC_Paytrace::TEXT_DOMAIN )
				),
				'default'     => 'separate',
				'class'       => 'chosen_select integration_' . $this->type,
				'css'         => 'min-width: 350px;',
				'description' => __( "How the payment forms are displayed on the Checkout page.<br/> '<strong>Together</strong>' will display both Cards and Checks forms under one payment method, inside the method description.<br/>'<strong>Separate</strong>' will display the forms as different payment methods.", \WC_Paytrace::TEXT_DOMAIN ),
			),
			
			'separated_forms_label_card'       => array(
				'title'       => __( 'Card Method Title', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'text',
				'default'     => __( 'Credit/Debit Card', \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( 'This controls the card method title which the user sees during checkout.', \WC_Paytrace::TEXT_DOMAIN ),
				'class'       => 'show_if_separated_forms_separate integration_' . $this->type,
			),
			'separated_forms_description_card' => array(
				'title'       => __( 'Card Method Description', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'textarea',
				'default'     => __( "Please make sure you enter your correct billing information.", \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( 'This controls the card method description which the user sees during checkout. Will show above the credit card fields.', \WC_Paytrace::TEXT_DOMAIN ),
				'class'       => 'show_if_separated_forms_separate integration_' . $this->type,
			),
			
			'separated_forms_label_check'       => array(
				'title'       => __( 'Check(ACH) Method Title', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'text',
				'default'     => __( 'Check(ACH)', \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( 'This controls the Check method title which the user sees during checkout.', \WC_Paytrace::TEXT_DOMAIN ),
				'class'       => 'show_if_separated_forms_separate integration_' . $this->type,
			),
			'separated_forms_description_check' => array(
				'title'       => __( 'Check(ACH) Method Description', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'textarea',
				'default'     => __( "Please make sure you enter your correct billing information.", \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( 'This controls the Check method description which the user sees during checkout. Will show above the Check fields.', \WC_Paytrace::TEXT_DOMAIN ),
				'class'       => 'show_if_separated_forms_separate integration_' . $this->type,
			),
			
			$this->type . '_display_settings_end' => array(
				'title'       => '<hr/>',
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_' . $this->type,
			),
		);
	}
	
	public function card_payment( $card_options ) {
		return array(
			'card_payment_settings_start' => array(
				'title'       => __( 'Card Payment Settings', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'title',
				'description' => '',
				'desc_tip'    => true,
				'class'       => 'integration_' . $this->type,
			),
			
			'available_cc' => array(
				'title'       => __( 'Accepted Cards', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'multiselect',
				'description' => __( 'Choose the cards you can and want to accept payments from.', \WC_Paytrace::TEXT_DOMAIN ),
				'options'     => $card_options,
				'class'       => 'wc-enhanced-select integration_' . $this->type,
				'css'         => 'min-width: 350px;',
				'default'     => array( 'VISA', 'MC', 'AMEX', 'DISCOVER', 'JCB' ),
				'desc_tip'    => true,
			),
			
			'card_payment_settings_end' => array(
				'title'       => '<hr/>',
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_' . $this->type,
			),
		);
	}
	
	public function check_payment() {
		return array(
			$this->type . '_check_payment_start' => array(
				'title'       => __( 'Check Payment Settings', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'title',
				'description' => '',
				'desc_tip'    => true,
				'class'       => 'integration_' . $this->type,
			),
			
			'support_check' => array(
				'type'        => 'checkbox',
				'label'       => __( 'Accept eCheck Payments', \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( 'Check the box, if you want to accept eCheck(ACH) payments.', \WC_Paytrace::TEXT_DOMAIN ),
				'default'     => 'yes',
				'desc_tip'    => true,
				'class'       => 'integration_' . $this->type,
			),
			
			'ach_payment_onhold' => array(
				'type'        => 'checkbox',
				'label'       => __( 'Set "On-Hold" status for orders paid by eCheck', \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __(
					"If enabled, it will mark the orders paid by Check as 'On-Hold' (Recommended: because the Check payments may be accepted, but still not processed), otherwise those orders will be marked as 'Processing'.", \WC_Paytrace::TEXT_DOMAIN
				),
				'desc_tip'    => true,
				'default'     => 'yes',
				'class'       => 'show_if_' . $this->type . '_support_check integration_' . $this->type,
			),
			
			$this->type . '_check_payment_end' => array(
				'title'       => '<hr/>',
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_' . $this->type,
			),
		);
	}
	
	public function vault() {
		return array(
			$this->type . '_vault_start' => array(
				'title'       => __( 'Vault Settings', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'title',
				'description' => '',
				'desc_tip'    => true,
				'class'       => 'integration_' . $this->type,
			),
			
			'save_customers' => array(
				'type'        => 'checkbox',
				'label'       => __( "Enable Payment Vault", \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __(
					"Check if you want to save the customers payment info on PayTrace secure servers. This option will allow the customers to save their info and use it in future payments without entering their information again. Only the last 4 digits of the Card, expiration date and their generated customer ID will be saved in the WooCommerce database. Customer will be able to delete or edit their saved information from their 'My Account' Page.", \WC_Paytrace::TEXT_DOMAIN
				),
				'desc_tip'    => true,
				'default'     => 'yes',
				'class'       => 'integration_' . $this->type,
			),
			
			'require_cvc_with_saved_cards' => array(
				'type'        => 'checkbox',
				'label'       => __( "Require CVC when paying with saved cards", \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( "Enable to require the customers to enter the card cvc when paying with a saved card.", \WC_Paytrace::TEXT_DOMAIN ),
				'desc_tip'    => true,
				'default'     => 'no',
				'class'       => 'show_if_' . $this->type . '_save_customers integration_' . $this->type,
			),
			
			'save_card_text' => array(
				'title'       => __( 'Save Your Payment Method Text', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'textarea',
				'description' => __( 'Enter the text to prompt your customers to save their payment method info for easier future payments.', \WC_Paytrace::TEXT_DOMAIN ),
				'default'     => __( 'Save to account', \WC_Paytrace::TEXT_DOMAIN ),
				'desc_tip'    => true,
				'class'       => 'show_if_' . $this->type . '_save_customers integration_' . $this->type,
			),
			
			$this->type . '_vault_end' => array(
				'title'       => '<hr/>',
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_' . $this->type,
			),
		);
	}
	
	public function transaction_settings() {
		return array(
			$this->type . '_transaction_specific' => array(
				'title'       => __( 'Transaction Settings', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_' . $this->type,
			),
			
			'trans_type' => array(
				'title'       => __( 'Transaction Type', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'select',
				'description' => __( 'The transaction type is the type of transaction you wish to process.', \WC_Paytrace::TEXT_DOMAIN ) . '<br/>' .
				                 sprintf( __( '%sSale%s means that the transaction is authorized and settled automatically.', \WC_Paytrace::TEXT_DOMAIN ), '<strong>', '</strong>' ) . '<br/>' .
				                 sprintf( __( '%sAuthorization%s means that the transaction is only authorized and will need to be manually settled.', \WC_Paytrace::TEXT_DOMAIN ), '<strong>', '</strong>' ),
				'options'     => array(
					'Sale'          => 'Sale',
					'Authorization' => 'Authorization'
				),
				'class'       => 'wc-enhanced-select integration_' . $this->type,
				'css'         => 'min-width: 350px;',
				'desc_tip'    => true,
				'default'     => '',
			
			),
			
			'send_order_description' => array(
				'type'        => 'checkbox',
				'label'       => __( 'Send Order Description with Transaction', \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( "Enable to send the order description to PayTrace. Description will contain the order items and/or the order number.", \WC_Paytrace::TEXT_DOMAIN ),
				'default'     => 'yes',
				'desc_tip'    => true,
				'class'       => 'integration_' . $this->type,
			),
			
			'send_transaction_receipt' => array(
				'type'        => 'checkbox',
				'label'       => __( 'Send Transaction Receipt', \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( "Will send a transaction receipt from Paytrace to the customer.", \WC_Paytrace::TEXT_DOMAIN ),
				'default'     => 'no',
				'desc_tip'    => false,
				'class'       => 'integration_' . $this->type,
			),
		);
	}
}