<?php

namespace WcPaytrace\Integrations\Post;

use WcPaytrace\Integrations\Settings\Commons;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since   2.0.0
 * @version 2.4.0 - Extending Commons setting class, so we can reuse setting sections
 * @author  VanboDevelops
 *
 *        Copyright: (c) 2017-2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Settings extends Commons {
	
	public function get_settings() {
		$settings = $this->credentials();
		$settings += $this->display_form();
		$settings += $this->card_payment( $this->get_gateway()->card_options );
		$settings += $this->check_payment();
		$settings += $this->vault();
		$settings += $this->transaction_settings();
		$settings += $this->proxy();
		$settings += $this->test_mode();
		
		return $settings;
	}
	
	public function proxy() {
		return array(
			'proxy' => array(
				'title'       => __( 'PayTrace HTTPS Proxy Server', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'text',
				'description' => __(
					"If your web host requires a proxy server for a SSL connection, enter here the proxy server and port. Leave empty, if you don't require a proxy server.", \WC_Paytrace::TEXT_DOMAIN
				),
				'desc_tip'    => true,
				'default'     => '',
				'class'       => 'integration_post',
			),
		);
	}
	
	public function test_mode() {
		return array(
			'testmode' => array(
				'title'       => __( 'Transaction Mode', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'checkbox',
				'label'       => __( 'Enable PayTrace Test Mode', \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __(
					'This option adds a test parameter to the payment request.
	                                <br/>It is not required to be enabled in order to make a test payment.
	                                If you use a <strong>test PayTrace User Name</strong> and <strong>test PayTrace Password</strong>,
	                                then you will be able to make test payments, even if test mode is disabled.
	                                <br/>When in test mode, a test payment will not return AVS and CSC match responses.
	                                <br/><strong>Disable Test Mode to accept live payments.</strong>', \WC_Paytrace::TEXT_DOMAIN
				),
				'default'     => 'no',
				'class'       => 'integration_post',
			),
		);
	}
}