<?php

namespace WcPaytrace\Integrations\Json;

use WcPaytrace\Integrations\Settings\Commons;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since   2.0.0
 * @version 2.4.0 - Extending Commons setting class, so we can reuse setting sections
 * @author  VanboDevelops
 *
 *        Copyright: (c) 2017-2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Settings extends Commons {
	
	public function get_settings() {
		$settings = $this->credentials();
		$settings += $this->display_form();
		$settings += $this->card_payment( $this->get_gateway()->card_options );
		$settings += $this->check_payment();
		$settings += $this->vault();
		$settings += $this->security_types();
		$settings += $this->transaction_settings();
		
		return $settings;
	}
	
	/**
	 * @since 2.4.0
	 * @return array
	 */
	public function security_types() {
		return array(
			'card_ui_type_settings_start' => array(
				'title'       => __( 'Client Side Encryption Settings', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_json',
			),
			
			'json_security_type' => array(
				'type'        => 'select',
				'title'       => __( "Security Types", \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( "Pick the security type to protect your Card form. The security type can lower you PCI-Compliance. 'Client-Side Encryption' has a SAQ-AE, 'Protect.js' has a SAQ-A PCI-Compliance level", \WC_Paytrace::TEXT_DOMAIN ),
				'desc_tip'    => true,
				'options'     => array(
					'json'       => __( 'No extra security', \WC_Paytrace::TEXT_DOMAIN ),
					'encryption' => __( 'Client-Side Encryption', \WC_Paytrace::TEXT_DOMAIN ),
					'protect'    => __( 'Protect.js', \WC_Paytrace::TEXT_DOMAIN ),
				),
				'default'     => 'protect',
				'class'       => 'integration_json',
			),
			
			'protect_form_theme' => array(
				'type'        => 'select',
				'title'       => __( "Form Design Theme", \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( "Pick a design theme for the payment form.", \WC_Paytrace::TEXT_DOMAIN ),
				'desc_tip'    => true,
				'options'     => array(
					'light'         => __( 'Light', \WC_Paytrace::TEXT_DOMAIN ),
					'light_rounded' => __( 'Light - Rounded Corners', \WC_Paytrace::TEXT_DOMAIN ),
					'dark'          => __( 'Dark', \WC_Paytrace::TEXT_DOMAIN ),
					'dark_rounded'  => __( 'Dark - Rounded Corners', \WC_Paytrace::TEXT_DOMAIN ),
				),
				'default'     => 'light_rounded',
				'class'       => 'show_if_json_use_protect_js integration_json',
			),
			
			'protect_exp_type' => array(
				'type'        => 'select',
				'title'       => __( "Expiration form type", \WC_Paytrace::TEXT_DOMAIN ),
				'description' => __( "The expiration fields can be dropdowns or text fields. Pick one.", \WC_Paytrace::TEXT_DOMAIN ),
				'desc_tip'    => true,
				'options'     => array(
					'dropdown' => __( 'Dropdown', \WC_Paytrace::TEXT_DOMAIN ),
					'textbox'  => __( 'Text', \WC_Paytrace::TEXT_DOMAIN ),
				),
				'default'     => 'textbox',
				'class'       => 'show_if_json_use_protect_js integration_json',
			),
			
			'json_public_key' => array(
				'title'       => __( 'Public Key: Contents', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'textarea',
				'description' => __( 'Please paste the public key contents.', \WC_Paytrace::TEXT_DOMAIN ),
				'default'     => '',
				'placeholder' => '',
				'desc_tip'    => false,
				'class'       => 'show_if_json_use_encryption_js integration_json',
			),
			
			'json_public_key_location' => array(
				'title'       => __( 'Location of Public Key', \WC_Paytrace::TEXT_DOMAIN ),
				'type'        => 'text',
				'description' => __( 'Deprecated: Use this option only if you the "Public Key: Contents" does not work. Enter the URL of the public key file. For example, add the public key file to the top folder location and reference it like this:  <code>https://domain.com/yourPublicKey.pem</code>', \WC_Paytrace::TEXT_DOMAIN ),
				'default'     => '',
				'placeholder' => 'https://domain.com/yourPublicKey.pem',
				'desc_tip'    => false,
				'class'       => 'show_if_json_use_encryption_js integration_json',
			),
			
			'card_ui_type_settings_end' => array(
				'title'       => '<hr/>',
				'type'        => 'title',
				'description' => '',
				'class'       => 'integration_json',
			),
		);
	}
}