<?php namespace WcPaytrace\Helpers;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since  2.7.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2022 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Protect_Template_Helpers {
	
	public static function get_protect_template( $id ) {
		$protect_map = array(
			'light' => array(
				'iframe' => array(
					'background' => '',
					'padding'    => '',
					'margin'     => '',
				),
				'code'   => array(
					'font_color'          => '#6d6d6d',
					'border_color'        => '#e0e0e0',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '0',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => 'rgba(26,26,26,.7)',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#ffffff',
					'height'              => '36px',
					'width'               => '100px',
					'padding_bottom'      => '0px',
				),
				
				'cc' => array(
					'font_color'          => '#6d6d6d',
					'border_color'        => '#e0e0e0',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '0px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => 'rgba(26,26,26,.7)',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#ffffff',
					'height'              => '36px',
					'width'               => 'calc(100% - 20px)',
					'padding_bottom'      => '0px',
				),
				
				'exp' => array(
					'font_color'          => '#6d6d6d',
					'border_color'        => '#e0e0e0',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '0px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => 'rgba(26,26,26,.7)',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#ffffff',
					'height'              => '36px',
					'width'               => '50px',
					'padding_bottom'      => '0px',
				),
			),
			
			'light_rounded' => array(
				'iframe' => array(
					'background' => '',
					'padding'    => '',
					'margin'     => '',
				),
				'code'   => array(
					'font_color'          => '#6d6d6d',
					'border_color'        => '#e0e0e0',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '6px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => 'rgba(26,26,26,.7)',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#ffffff',
					'height'              => '36px',
					'width'               => '100px',
					'padding_bottom'      => '0px',
				),
				
				'cc' => array(
					'font_color'          => '#6d6d6d',
					'border_color'        => '#e0e0e0',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '6px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => 'rgba(26,26,26,.7)',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#ffffff',
					'height'              => '36px',
					'width'               => 'calc(100% - 20px)',
					'padding_bottom'      => '0px',
				),
				
				'exp' => array(
					'font_color'          => '#6d6d6d',
					'border_color'        => '#e0e0e0',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '6px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => 'rgba(26,26,26,.7)',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#ffffff',
					'height'              => '36px',
					'width'               => '50px',
					'padding_bottom'      => '0px',
				),
			),
			
			'dark' => array(
				'iframe' => array(
					'background' => '#242424',
					'padding'    => '10px',
				),
				'code'   => array(
					'font_color'          => '#ffffff',
					'border_color'        => '#505050',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '0px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => '#ffffff',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#2B2B2B',
					'height'              => '36px',
					'width'               => '100px',
					'padding_bottom'      => '0px',
				),
				
				'cc' => array(
					'font_color'          => '#ffffff',
					'border_color'        => '#505050',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '0px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => '#ffffff',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#2B2B2B',
					'height'              => '36px',
					'width'               => 'calc(100% - 20px)',
					'padding_bottom'      => '0px',
				),
				
				'exp' => array(
					'font_color'          => '#ffffff',
					'border_color'        => '#505050',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '0px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => '#ffffff',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#2B2B2B',
					'height'              => '36px',
					'width'               => '50px',
					'padding_bottom'      => '0px',
				),
			),
			
			'dark_rounded' => array(
				'iframe' => array(
					'background' => '#242424',
					'padding'    => '10px',
				),
				'code'   => array(
					'font_color'          => '#ffffff',
					'border_color'        => '#505050',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '6px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => '#ffffff',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#2B2B2B',
					'height'              => '36px',
					'width'               => '100px',
					'padding_bottom'      => '0px',
				),
				
				'cc' => array(
					'font_color'          => '#ffffff',
					'border_color'        => '#505050',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '6px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => '#ffffff',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#2B2B2B',
					'height'              => '36px',
					'width'               => 'calc(100% - 20px)',
					'padding_bottom'      => '0px',
				),
				
				'exp' => array(
					'font_color'          => '#ffffff',
					'border_color'        => '#505050',
					'border_style'        => 'solid',
					'font_size'           => '16px',
					'input_border_radius' => '6px',
					'input_border_width'  => '1px',
					'input_font'          => 'Times New Roman, arial, fantasy',
					'input_font_weight'   => '400',
					'input_margin'        => '5px 0px 5px 0px',
					'input_padding'       => '0px 10px 0px 10px',
					'label_color'         => '#ffffff',
					'label_size'          => '16px',
					'label_width'         => '150px',
					'label_font'          => 'Times New Roman, sans-serif, serif',
					'label_font_weight'   => 'light',
					'label_margin'        => '5px 0px 0px 0px',
					'label_padding'       => '0px',
					'label_border_style'  => 'none',
					'label_border_color'  => '',
					'label_border_radius' => '',
					'label_border_width'  => '',
					'background_color'    => '#2B2B2B',
					'height'              => '36px',
					'width'               => '50px',
					'padding_bottom'      => '0px',
				),
			),
		);
		
		return apply_filters( 'wc_paytrace_protect_form_theme', wc_get_var( $protect_map[ $id ], array() ), $protect_map, $id );
	}
}