<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Helper methods
 *
 * @since  2.4.1
 * @author VanboDevelops
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class WC_Paytrace_Helpers {
	
	/**
	 * Is the customer on the payment methods page
	 * @return bool
	 */
	public static function is_payment_methods_page() {
		global $wp;
		
		$page_id = wc_get_page_id( 'myaccount' );
		
		return $page_id && is_page( $page_id ) && isset( $wp->query_vars['payment-methods'] );
	}
	
	/**
	 * Is this the change method page
	 * @return bool
	 */
	public static function is_change_method_page() {
		
		if ( ! class_exists( 'WC_Subscriptions_Change_Payment_Gateway' ) ) {
			return false;
		}
		
		if ( ! isset( $_GET['pay_for_order'] ) ) {
			return false;
		}
		
		return \WC_Subscriptions_Change_Payment_Gateway::$is_request_to_change_payment;
	}
}