<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.1.3
 * @author VanboDevelops
 *
 *        Copyright: (c) 2018 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class WC_Paytrace_Debug {
	
	/**
	 * Is debug mode enabled
	 * @var bool
	 */
	private $is_debug_enabled;
	/**
	 * WC Logger object
	 * @var object
	 */
	private $log;
	private $gateway_id;
	
	public function __construct( $gateway_id ) {
		$this->gateway_id = $gateway_id;
	}
	
	/**
	 * Check, if debug logging is enabled
	 *
	 * @since 2.1.3
	 * @return bool
	 */
	public function is_debug_enabled() {
		if ( $this->is_debug_enabled ) {
			return $this->is_debug_enabled;
		} else {
			$settings = get_option( 'woocommerce_' . $this->gateway_id . '_settings' );
			
			$this->is_debug_enabled = isset( $settings['debug'] ) && 'yes' == $settings['debug'];
			
			return $this->is_debug_enabled;
		}
	}
	
	/**
	 * Add debug log message
	 *
	 * @since 2.1.3
	 *
	 * @param string $message
	 * @param string $handle The handle of the log file
	 * @param string $level  Level of severity: emergency|alert|critical|error|warning|notice|info|debug
	 *
	 * @return bool
	 */
	public function add_debug_log( $message, $handle = 'paytrace', $level = 'debug' ) {
		
		if ( ! $this->is_debug_enabled() ) {
			return false;
		}
		
		if ( ! is_object( $this->log ) ) {
			$this->log = \WC_Paytrace_Compat::get_wc_logger();
		}
		
		if ( \WC_Paytrace_Compat::is_wc_3_0() ) {
			if ( ! \WC_Log_Levels::is_valid_level( $level ) ) {
				$level = 'debug';
			}
			$this->log->log( $level, $message, array( 'source' => $handle ) );
		} else {
			$this->log->add( $handle, $message );
		}
	}
}