<?php

namespace WcPaytrace\Api\Post;

use WcPaytrace\Abstracts\Validator as Abstract_Validator;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Validator extends Abstract_Validator {
	
	/**
	 * @var \WcPaytrace\Api\Client
	 */
	public $client;
	public $map_props_lengths = array(
		'BADDRESS'    => "50",
		'BADDRESS2'   => "50",
		'BZIP'        => "10",
		'BNAME'       => "50",
		'BCITY'       => "50",
		'BSTATE'      => "2",
		'BCOUNTRY'    => "2",
		'SADDRESS'    => "50",
		'SADDRESS2'   => "50",
		'SZIP'        => "10",
		'SNAME'       => "50",
		'SCITY'       => "50",
		'SSTATE'      => "2",
		'SCOUNTRY'    => "2",
		'DESCRIPTION' => "255",
		'EMAIL'       => "50",
		'INVOICE'     => "50",
	);
	public $map_props_text = array(
		'DESCRIPTION',
	);
	
	/**
	 * Validator constructor.
	 *
	 * @param \WcPaytrace\Api\Client $client
	 */
	public function __construct( $client ) {
		parent::__construct( $client );
		$this->map_props_lengths     = apply_filters( 'wc_paytrace_post_map_props_lengths', $this->map_props_lengths );
		$this->map_props_text        = apply_filters( 'wc_paytrace_post_map_props_text', $this->map_props_text );
		$this->restricted_characters = apply_filters( 'wc_paytrace_post_restricted_characters', array(
			'|',
			'~'
		) );
	}
	
	/**
	 * Formats the given property length according to the 'map_props_lengths' map
	 *
	 * @since 2.0
	 *
	 * @param $key
	 * @param $value
	 *
	 * @return string
	 */
	public function format_property_length( $key, $value ) {
		if ( isset( $this->map_props_lengths[ $key ] ) ) {
			$value = substr( $value, 0, $this->map_props_lengths[ $key ] );
		}
		
		return $value;
	}
	
	/**
	 * Formats the given property text according to the 'map_props_text' map
	 *
	 * @since 2.0
	 *
	 * @param $key
	 * @param $value
	 *
	 * @return mixed|string
	 */
	public function format_property_text( $key, $value ) {
		if ( in_array( $key, $this->map_props_text ) ) {
			$value = $this->html_entity_decode_numeric( $value );
		}
		
		return $value;
	}
}