<?php

namespace WcPaytrace\Api\Post\Services;

use WcPaytrace\Api\Post\Requests;
use WcPaytrace\Api\Post\Services;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Vault extends Requests {
	
	public $services;
	public $validator;
	
	public function __construct( Services $services, $validator ) {
		$this->services  = $services;
		$this->validator = $validator;
		$this->set_username( $services->username );
		$this->set_password( $services->password );
		$this->set_terms( 'Y' );
		$this->proxy = $services->proxy;
	}
	
	/**
	 * Processes a create profile request
	 *
	 * @since 2.0
	 *
	 * @param $params
	 *
	 * @return mixed|\WcPaytrace\Api\Post\Response
	 * @throws \Exception
	 */
	public function create_profile( $params ) {
		$this->set_method( 'CreateCustomer' );
		
		$this->set_props( $params );
		
		$request = $this->format_request();
		
		$response = $this->send_request( $request );
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
	
	/**
	 * Processes an update profile request
	 *
	 * @since 2.0
	 *
	 * @param $params
	 *
	 * @return mixed|\WcPaytrace\Api\Post\Response
	 * @throws \Exception
	 */
	public function update_profile( $params ) {
		$this->set_method( 'UpdateCustomer' );
		
		$this->set_props( $params );
		
		$request = $this->format_request();
		
		$response = $this->send_request( $request );
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
	
	/**
	 * Processes a delete profile request
	 *
	 * @since 2.0
	 *
	 * @param $params
	 *
	 * @return mixed|\WcPaytrace\Api\Post\Response
	 * @throws \Exception
	 */
	public function delete_profile( $params ) {
		$this->set_method( 'DeleteCustomer' );
		
		$this->set_props( $params );
		
		$request = $this->format_request();
		
		$response = $this->send_request( $request );
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
}