<?php

namespace WcPaytrace\Api\Post\Services;

use WcPaytrace\Api\Post\Requests;
use WcPaytrace\Api\Post\Services;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Transaction extends Requests {
	
	public $services;
	
	public function __construct( Services $services, $validator ) {
		$this->services  = $services;
		$this->validator = $validator;
		$this->set_username( $services->username );
		$this->set_password( $services->password );
		$this->set_terms( 'Y' );
		$this->proxy = $services->proxy;
		
		if ( $this->services->test_mode ) {
			$this->set_test( 'Y' );
		}
	}
	
	/**
	 * Processes a transaction request
	 *
	 * @since 2.0
	 *
	 * @param $props
	 * @throws \Exception
	 * @return mixed|\WcPaytrace\Api\Post\Response
	 */
	public function process_transaction( $props ) {
		if ( 'ProcessTranx' == $props['METHOD'] ) {
			// Card payments just run the set transaction type
			$props['TRANXTYPE'] = $this->services->client->get_gateway()->get_transaction_authorization_type( 'card' );
		} elseif ( 'ProcessCheck' == $props['METHOD'] ) {
			// Check payments transaction type is either 'Hold' or 'Sale'.
			$props['CHECKTYPE'] = $this->services->client->get_gateway()->get_transaction_authorization_type( 'check' );
		}
		
		$this->set_props( $props );
		
		$request = $this->format_request();
		
		$response = $this->send_request( $request );
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
}