<?php

namespace WcPaytrace\Api\Post\Services;

use WcPaytrace\Api\Post\Requests;
use WcPaytrace\Api\Post\Services;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since 2.3.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2018 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Receipt extends Requests {
	
	/**
	 * @var Services
	 */
	public $services;
	
	public function __construct( Services $services, $validator ) {
		$this->services  = $services;
		$this->validator = $validator;
		$this->set_username( $services->username );
		$this->set_password( $services->password );
		$this->set_terms( 'Y' );
		$this->proxy = $services->proxy;
		
		if ( $this->services->test_mode ) {
			$this->set_test( 'Y' );
		}
	}
	
	/**
	 * Processes the email receipt request
	 *
	 * @since 2.3.0
	 *
	 * @param $props
	 *
	 * @return mixed|\WcPaytrace\Api\Post\Response
	 * @throws \Exception
	 */
	public function send_receipt( $props ) {
		if ( ! isset( $props['METHOD'] ) ) {
			$props['METHOD'] = 'EmailReceipt';
		}

		$this->set_props( $props );
		
		$request = $this->format_request();
		
		$response = $this->send_request( $request );
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
}