<?php

namespace WcPaytrace\Api\Post;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Response extends \WcPaytrace\Abstracts\Response {
	
	public function __construct( $response ) {
		parent::__construct( $response );
	}
	
	/**
	 * Parses the provided response
	 *
	 * @since 2.0
	 *
	 * @param string $body
	 *
	 * @return object|bool
	 */
	public function parse_response_body( $body ) {
		$result = new \stdClass();
		if ( $body == "" ) {
			$result->ERROR .= "The request did not receive a valid response from the network, please try again.";
		} else {
			$l_HasAPipe  = strpos( $body, "|" );
			$l_HasATilde = strpos( $body, "~" );
			if ( $l_HasAPipe === false || $l_HasATilde == false ) {
				$result->ERROR .= "The request did not receive a valid response from the network, please try again.";
			} else {
				// Parse through the response and put pairs into an array
				$l_ResponseArray = explode( '|', $body );
				$l_ArrayOfPairs  = array();
				foreach ( $l_ResponseArray as $l_NameValuePair ) {
					$l_HasATilde = strpos( $l_NameValuePair, "~" );
					if ( $l_HasATilde == true ) {
						$l_NameValuePairArray                       = explode( '~', $l_NameValuePair );
						$l_ArrayOfPairs[ $l_NameValuePairArray[0] ] = $l_NameValuePairArray[1];
					}
				}
				
				// Loop through the array of pairs and put the data into the class properties
				foreach ( $l_ArrayOfPairs as $l_Name => $l_Value ) {
					$result->{$l_Name} = $l_Value;
				}
			}
		}
		
		return $result;
	}
	
	public function did_error_occur() {
		return '' != $this->get_error();
	}
	
	public function was_capture_approved() {
		return false == $this->did_error_occur();
	}
	
	public function was_transaction_approved() {
		return false == $this->did_error_occur() && '' != $this->get_approval_code();
	}
	
	public function was_echeck_transaction_approved() {
		return false == $this->did_error_occur() && '' != $this->get_response() && '' != $this->get_check_identifier();
	}
	
	public function was_customer_request_approved() {
		return false == $this->did_error_occur() && '' != $this->get_customer_id();
	}
	
	public function was_refund_approved( $type = 'card' ) {
		$refund_approved = false;
		if ( false == $this->did_error_occur() ) {
			if ( 'check' == $type ) {
				// We processed Check method
				if ( '' != $this->get_check_identifier() && '' != $this->get_response() ) {
					$refund_approved = true;
				}
			} else {
				// We processed Card method
				if ( '' != $this->get_transaction_id() && '' != $this->get_response() ) {
					$refund_approved = true;
				}
			}
		}
		
		return $refund_approved;
	}
	
	public function get_ach_code() {
		return $this->get_prop( $this->get_accepted_response_body(), 'ACHCODE' );
	}
	
	public function get_ach_message() {
		return $this->get_prop( $this->get_accepted_response_body(), 'ACHMSG' );
	}
	
	public function get_approval_code() {
		return $this->get_prop( $this->get_accepted_response_body(), 'APPCODE' );
	}
	
	public function get_approval_message() {
		return $this->get_prop( $this->get_accepted_response_body(), 'APPMSG' );
	}
	
	public function get_avs_response() {
		return $this->get_prop( $this->get_accepted_response_body(), 'AVSRESPONSE' );
	}
	
	public function get_check_identifier() {
		return $this->get_prop( $this->get_accepted_response_body(), 'CHECKIDENTIFIER' );
	}
	
	public function get_csc_response() {
		return $this->get_prop( $this->get_accepted_response_body(), 'CSCRESPONSE' );
	}
	
	public function get_cust_id() {
		return $this->get_prop( $this->get_accepted_response_body(), 'CUSTID' );
	}
	
	public function get_customer_id() {
		return $this->get_prop( $this->get_accepted_response_body(), 'CUSTID' );
	}
	
	public function get_profile_id() {
		return $this->get_prop( $this->get_accepted_response_body(), 'CUSTOMERID' );
	}
	
	public function get_error() {
		$error = $this->get_prop( $this->get_accepted_response_body(), 'ERROR' );
		
		return $error;
	}
	
	public function get_response_code() {
		return (int) $this->get_prop( $this->get_accepted_response_body(), 'RESPONSE' );
	}
	
	public function get_response() {
		return $this->get_prop( $this->get_accepted_response_body(), 'RESPONSE' );
	}
	
	public function get_transaction_id() {
		// If we have a check transaction id, we will return that
		if ( '' != $this->get_check_identifier() ) {
			return $this->get_check_identifier();
		}
		
		return $this->get_prop( $this->get_accepted_response_body(), 'TRANSACTIONID' );
	}
}