<?php

namespace WcPaytrace\Api\Json;

use WcPaytrace\Abstracts\Validator as Abstract_Validator;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Validator extends Abstract_Validator {
	
	/**
	 * @var \WcPaytrace\Api\Client
	 */
	public $client;

	/**
	 * Validator constructor.
	 *
	 * @since 2.0
	 *
	 * @param \WcPaytrace\Api\Client $client
	 */
	public function __construct( $client ) {
		parent::__construct( $client );
		$this->restricted_characters = apply_filters( 'wc_paytrace_json_restricted_characters', array(
			'|',
		) );
	}
}