<?php

namespace WcPaytrace\Api\Json\Services;

use WcPaytrace\Api\Json\Requests;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.0.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Vault extends Requests {
	
	/**
	 * Processes the Create profile
	 *
	 * @since 2.0
	 *
	 * @param $params
	 *
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 * @throws \Exception
	 */
	public function create_profile( $params ) {
		$this->action_endpoint = '/customer/create';
		if ( isset( $params['hpf_token'] ) ) {
			$this->action_endpoint = '/customer/pt_protect_create';
		}
		
		$this->set_props( $params );
		
		return $this->parse_response( $this->send() );
	}
	
	/**
	 * Processes the Update profile
	 *
	 * @since 2.0
	 *
	 * @param $params
	 *
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 * @throws \Exception
	 */
	public function update_profile( $params ) {
		$this->action_endpoint = '/customer/update';
		if ( isset( $params['hpf_token'] ) ) {
			$this->action_endpoint = '/customer/pt_protect_update';
		}
		
		$this->set_props( $params );
		
		return $this->parse_response( $this->send() );
	}
	
	/**
	 * Processes the Delete profile
	 *
	 * @since 2.0
	 *
	 * @param $params
	 *
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 * @throws \Exception
	 */
	public function delete_profile( $params ) {
		$this->action_endpoint = '/customer/delete';
		
		$this->set_props( $params );
		
		return $this->parse_response( $this->send() );
	}
	
	/**
	 *
	 * /v1/transactions/export/by_id
	 *
	 * @param $props
	 *
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 * @throws \Exception
	 */
	public function export_profile( $props ) {
		$this->action_endpoint = "/customer/export";
		
		$this->set_props( $props );
		
		return $this->parse_response( $this->send() );
	}
}