<?php

namespace WcPaytrace\Api\Json\Services;

use WcPaytrace\Api\Json\Requests;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.0.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Transaction extends Requests {
	
	/**
	 * Processes the transaction requests
	 *
	 * // Cards:
	 * // - /v1/transactions/authorization/keyed - Keyed
	 * // - /v1/transactions/authorization/pt_protect - protect.js
	 * // - /v1/transactions/authorization/by_customer - Vault
	 * // - /v1/transactions/sale/keyed - Keyed
	 * // - /v1/transactions/sale/pt_protect - protect.js
	 * // - /v1/transactions/sale/by_customer - Vault
	 * // Checks:
	 * // - /v1/checks/hold/by_account - Keyed
	 * // - /v1/checks/hold/by_customer - Vault
	 * // - /v1/checks/sale/by_account - Keyed
	 * // - /v1/checks/sale/by_customer - Vault
	 *
	 * @since 2.0
	 *
	 * @param $props
	 *
	 * @throws \Exception
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 */
	public function process_transaction( $props ) {
		$authorization_type = $this->get_authorization_type( $props );
		$transaction_type   = $this->get_transaction_type( $props );
		
		if ( isset( $props['customer_id'] ) ) {
			$action = 'by_customer';
		} else {
			$action = 'keyed';
			if ( 'checks' == $transaction_type ) {
				$action = 'by_account';
			}
			
			if ( isset( $props['hpf_token'] ) ) {
				$action = 'pt_protect';
			}
		}
		
		$this->action_endpoint = "/{$transaction_type}/{$authorization_type}/{$action}";
		
		unset( $props['authorization_type'] );
		unset( $props['transaction_type'] );
		
		$this->set_props( $props );
		
		$response = $this->send();
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
	
	public function export_transaction( $props ) {
		$this->action_endpoint = "/transactions/export/by_id";
		
		unset( $props['authorization_type'] );
		unset( $props['transaction_type'] );
		
		$this->set_props( $props );
		
		$response = $this->send();
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
	
	
}