<?php

namespace WcPaytrace\Api\Json\Services;

use WcPaytrace\Api\Json\Requests;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since 2.0.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Refund extends Requests {
	
	/**
	 * Processes the refund request
	 *
	 * @param $props
	 *
	 * @throws \Exception
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 */
	public function process_refund( $props ) {
		
		$transaction_type = $this->get_transaction_type( $props );
		if ( ! empty( $props['transaction_id'] ) ) {
			$action = 'for_transaction';
			if ( 'checks' == $transaction_type ) {
				$action = 'by_transaction';
			}
		} else {
			$action = 'to_customer';
			if ( 'checks' == $transaction_type ) {
				$action = 'by_customer';
			}
		}
		
		$this->action_endpoint = "/{$transaction_type}/refund/{$action}";
		
		$this->set_props( $props );
		
		$response = $this->send();
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
}