<?php

namespace WcPaytrace\Api\Json\Services;

use WcPaytrace\Api\Json\Requests;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.3.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2018 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Receipt extends Requests {
	
	/**
	 * Processes the email receipt request
	 *
	 * Cards:
	 *      /v1/transactions/email_receipt
	 * Checks:
	 *      /v1/checks//email_receipt
	 *
	 * @since 2.3.0
	 *
	 * @param $props
	 *
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 * @throws \Exception
	 */
	public function send_receipt( $props ) {
		
		$transaction_type      = $this->get_transaction_type( $props );
		$this->action_endpoint = "/{$transaction_type}/email_receipt";
		
		$this->set_props( $props );
		
		$response = $this->send();
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
}