<?php

namespace WcPaytrace\Api\Json\Services;

use WcPaytrace\Api\Json\Requests;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since 2.0.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Capture extends Requests {
	
	/**
	 * Processes the capture request
	 *
	 * Cards:
	 *      /v1/transactions/authorization/capture
	 * Checks:
	 *      /v1/checks/manage/fund
	 *
	 * @since 2.0
	 *
	 * @param $props
	 *
	 * @return mixed|\WcPaytrace\Api\Json\Response
	 * @throws \Exception
	 */
	public function process_capture( $props ) {
		
		$transaction_type      = $this->get_transaction_type( $props );
		$this->action_endpoint = "/{$transaction_type}/authorization/capture";
		if ( 'checks' == $transaction_type ) {
			$this->action_endpoint = "/{$transaction_type}/manage/fund";
		}
		
		$this->set_props( $props );
		
		$response = $this->send();
		
		$response = $this->parse_response( $response );
		
		return $response;
	}
}