<?php

namespace WcPaytrace\Api\Json;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Response extends \WcPaytrace\Abstracts\Response {
	
	public function __construct( $response ) {
		parent::__construct( $response );
	}
	
	/**
	 * Returns whether request error occurred
	 *
	 * @since 2.0
	 *
	 * @return bool
	 */
	public function did_error_occur() {
		$result = false;
		
		if ( 500 <= (int) $this->get_headers_response_code() ) {
			return true;
		}

		$multi_errors = $this->get_errors();
		if ( null !== $this->get_error() || ! empty( $multi_errors ) ) {
			$result = true;
		}
		
		return $result;
	}
	
	/**
	 * Parses the response body into and object or returns false
	 *
	 * @since 2.0
	 *
	 * @param $body
	 *
	 * @return object|bool
	 * @throws \Exception
	 */
	public function parse_response_body( $body ) {
		
		if ( empty( $body ) ) {
			throw new \Exception( __( $this->accepted_response['response']['code'] . ' ' . $this->accepted_response['response']['message'] ) );
		}
		
		return $this->json_decode( $body );
	}
	
	/**
	 * Checks and decodes the json string
	 *
	 * @since 2.0
	 *
	 * @param string $string
	 *
	 * @return object|bool
	 */
	public function json_decode( $string ) {
		if ( $this->check_json_response_body( $string ) ) {
			return json_decode( $string );
		}
		
		return false;
	}
	
	/**
	 * Checks the response body is JSON data
	 *
	 * @since 2.0
	 *
	 * @param $response_body
	 *
	 * @return bool
	 */
	public function check_json_response_body( $response_body ) {
		if ( 0 !== strpos( $response_body, '{' ) && 0 !== strpos( $response_body, '[{' ) ) {
			return false;
		}
		
		return true;
	}

	/**
	 * Retrieves the customers prop form the response
	 * @return mixed
	 */
	public function get_customers() {
		return $this->get_prop( $this->get_accepted_response_body(), 'customers' );
	}
}