<?php

namespace WcPaytrace\Api\Json;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  2.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class OAuth2 extends Requests {
	
	public function __construct( Services $services, Validator $validator ) {
		$this->services  = $services;
		$this->validator = $validator;
		$this->set_username( $services->username );
		$this->set_password( $services->password );
		$this->api_version_endpoint = '';
	}
	
	/**
	 * Returns the endpoint for the request
	 *
	 * @since 2.0
	 *
	 * @return string
	 */
	public function get_action_endpoint() {
		return '/oauth/token';
	}
	
	/**
	 * Returns the request headers
	 *
	 * @since 2.0
	 *
	 * @return array
	 */
	public function get_request_headers() {
		return array(
			'HTTP Protocol' => 'HTTP/1.1',
			'Accept'        => "*/*",
			'Content-Type'  => "application/x-www-form-urlencoded; charset=UTF-8"
		);
	}
	
	/**
	 * Requests an access token from the JSON API
	 *
	 * @since 2.0
	 *
	 * @return string
	 * @throws \Exception
	 */
	public function request_token() {
		$this->set_grant_type( 'password' );
		
		$response = $this->parse_response( $this->send() );
		
		if ( 'bearer' != strtolower( $response->get_token_type() ) && '' != $response->get_access_token() ) {
			$description = $response->get_error_description();
			$error       = $response->get_error();

			$message = __( 'Could not generate PayTrace access token. Please try again or contact administrator.', \WC_Paytrace::TEXT_DOMAIN );
			if ( '' != $error ) {
				$message .= ' ' . sprintf( __( 'Error: %s', \WC_Paytrace::TEXT_DOMAIN ), $error );
			}

			if ( '' != $description ) {
				$message .= ' ' . sprintf( __( 'Error Message: %s', \WC_Paytrace::TEXT_DOMAIN ), $description );
			}

			throw new \Exception( $message );
		}
		
		set_transient( 'wc_paytrace_json_access_token', $response->get_access_token(), (int) $response->get_expires_in() - 300 );
		
		return $response->get_access_token();
	}
	
	/**
	 * Formats the request. In this case the request is returned unformatted
	 *
	 * @since 2.0
	 *
	 * @return mixed
	 */
	public function format() {
		return $this->request;
	}
}