<?php

namespace WcPaytrace\Api;

use WcPaytrace\Api\Post\Services as Post_Services;
use WcPaytrace\Api\Json\Services as Json_Services;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles general routing to the appropriate integration service.
 * Will load the gateway and provide general methods to support the services
 *
 * @since  2.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2017 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Client {
	
	protected $username;
	protected $password;
	protected $test_mode;
	protected $base_url;
	protected $gateway;
	
	/**
	 * WcPaytrace\Api\Client constructor.
	 *
	 * @param \WC_Paytrace_Gateway $gateway
	 *
	 * @throws \Exception
	 */
	public function __construct( $gateway ) {
		$this->gateway = $gateway;
	}
	
	/**===============================
	 * Services
	 * ================================*/
	
	/**
	 * Returns the Post Services object
	 *
	 * @since 2.0
	 *
	 * @return Post_Services
	 */
	public function get_post_services() {
		return new Post_Services( $this );
	}
	
	/**
	 * Returns the Json Services
	 *
	 * @since 2.0
	 *
	 * @return Json_Services
	 */
	public function get_json_services() {
		return new Json_Services( $this );
	}
	
	/**===============================
	 * Getters
	 * =================================*/
	/**
	 * Returns gateway
	 *
	 * @since 2.0
	 *
	 * @return \WC_Paytrace_Gateway
	 */
	public function get_gateway() {
		return $this->gateway;
	}
	
	/**
	 * Returns the test mode
	 *
	 * @since 2.0
	 *
	 * @return bool
	 */
	public function is_testmode() {
		return 'yes' == $this->get_gateway()->get_option( 'testmode', 'no' );
	}
	
	public function get_user_name() {
		return $this->get_gateway()->get_option( 'user_name' );
	}
	
	public function get_password() {
		return $this->get_gateway()->get_option( 'password' );
	}
	
	/**
	 * Returns the set value of transaction type
	 *
	 * @since 2.0
	 *
	 * @return mixed
	 */
	public function get_transaction_type() {
		return $this->get_gateway()->get_option( 'trans_type' );
	}
	
	public function get_save_customers() {
		return $this->get_gateway()->get_option( 'save_customers' );
	}
	
	/**
	 * @return array|mixed
	 */
	public function get_available_cc() {
		return $this->get_gateway()->get_option( 'available_cc', array() );
	}
	
	/**
	 * @return bool
	 */
	public function use_encryption() {
		return 'encryption' === $this->get_gateway()->get_security_type();
	}
}