<?php

namespace WcPaytrace\Admin;

use WcPaytrace\Helpers\Factories;

/**
 * Plugin System Status
 *
 * @since      3.5.0
 */
class System_Status {
	
	public $gateway;
	public $gateway_id;
	public $plugin_license_id;
	
	public function __construct( $gateway_id, $plugin_license_id = 0 ) {
		$this->gateway_id        = $gateway_id;
		$this->plugin_license_id = $plugin_license_id;
	}
	
	/**
	 * Attach callbacks
	 *
	 * @since 3.5.0
	 */
	public function hooks() {
		add_filter( 'woocommerce_system_status_report', array( $this, 'render_system_status_items' ), 100 );
	}
	
	public function get_gateway() {
		if ( null == $this->gateway ) {
			$this->gateway = Factories::get_gateway( $this->gateway_id );
		}
		
		return $this->gateway;
	}
	
	/**
	 * Renders the Subscription information in the WC status page
	 *
	 * @since 3.5.0
	 */
	public function render_system_status_items() {
		$integration = $this->get_gateway()->get_option( 'integration' );
		
		$status_data['wc_paytrace_integration'] = array(
			'name'      => _x( 'Integration type', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
			'label'     => 'Integration type',
			'note'      => $integration,
			'mark'      => 'yes',
			'mark_icon' => '',
		);
		
		$status_data['wc_paytrace_separate'] = array(
			'name'  => _x( 'Separated Forms', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
			'label' => 'Separated Forms',
			'note'  => $this->get_gateway()->separated_forms ? __( 'Yes', \WC_Paytrace::TEXT_DOMAIN ) : __( 'No', \WC_Paytrace::TEXT_DOMAIN ),
			'mark'  => 'yes' == $this->get_gateway()->separated_forms ? 'yes' : 'error',
			
			'mark_icon' => '',
		);
		
		$status_data['wc_paytrace_accept_checks'] = array(
			'name'  => _x( 'Accept Checks', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
			'label' => 'Accept Checks',
			'note'  => $this->get_gateway()->support_check ? __( 'Yes', \WC_Paytrace::TEXT_DOMAIN ) : __( 'No', \WC_Paytrace::TEXT_DOMAIN ),
			'mark'  => 'yes' == $this->get_gateway()->support_check ? 'yes' : 'error',
			
			'mark_icon' => '',
		);
		
		$status_data['wc_paytrace_vault_payments'] = array(
			'name'  => _x( 'Allow Vault Payments', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
			'label' => 'Allow Vault Payments',
			'note'  => $this->get_gateway()->save_customers ? __( 'Yes', \WC_Paytrace::TEXT_DOMAIN ) : __( 'No', \WC_Paytrace::TEXT_DOMAIN ),
			'mark'  => 'yes' == $this->get_gateway()->save_customers ? 'yes' : 'error',
			
			'mark_icon' => '',
		);
		
		$status_data['wc_paytrace_require_csc'] = array(
			'name'      => _x( 'Require CSC', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
			'label'     => 'Require CSC',
			'note'      => 'yes' == $this->get_gateway()->get_option( 'require_cvc_with_saved_cards' ) ? __( 'Yes', \WC_Paytrace::TEXT_DOMAIN ) : __( 'No', \WC_Paytrace::TEXT_DOMAIN ),
			'mark'      => 'yes' == $this->get_gateway()->get_option( 'require_cvc_with_saved_cards' ) ? 'yes' : 'error',
			'mark_icon' => '',
		);
		
		if ( 'json' == $integration ) {
			$status_data['wc_paytrace_security_type'] = array(
				'name'      => _x( 'Security Type', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
				'label'     => 'Security Type',
				'note'      => ucfirst( $this->get_gateway()->get_security_type() ),
				'mark'      => '' == $this->get_gateway()->get_security_type() ? 'error' : 'yes',
				'mark_icon' => '',
			);
			
			if ( 'protect' == $this->get_gateway()->get_security_type() ) {
				$status_data['wc_paytrace_theme'] = array(
					'name'      => _x( 'Protect: Theme', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
					'label'     => 'Protect: Theme',
					'note'      => $this->get_gateway()->get_option( 'protect_form_theme', 'light_rounded' ),
					'mark'      => 'yes',
					'mark_icon' => '',
				);
				
				$status_data['wc_paytrace_exp_type'] = array(
					'name'      => _x( 'Exp Field Type', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
					'label'     => 'Exp Field Type',
					'note'      => ucfirst( $this->get_gateway()->get_option( 'protect_exp_type', 'textbox' ) ),
					'mark'      => 'yes',
					'mark_icon' => '',
				);
			}
		} else {
			$testmode = 'yes' == $this->get_gateway()->testmode;
			
			$status_data['wc_paytrace_testmode'] = array(
				'name'      => _x( 'Testmode', 'Label on WooCommerce -> System Status page', \WC_Paytrace::TEXT_DOMAIN ),
				'label'     => 'Testmode',
				'note'      => $testmode ? __( 'Yes', \WC_Paytrace::TEXT_DOMAIN ) : __( 'No', \WC_Paytrace::TEXT_DOMAIN ),
				'mark'      => $testmode ? 'yes' : 'error',
				'mark_icon' => '',
			);
		}
		
		$system_status_sections = array(
			array(
				'title'   => __( 'Paytrace Gateway', \WC_Paytrace::TEXT_DOMAIN ),
				'tooltip' => __( 'System information about WooCommerce Paytrace plugin.', \WC_Paytrace::TEXT_DOMAIN ),
				'data'    => apply_filters( 'wc_paytrace_system_status', $status_data ),
			),
		);
		
		foreach ( $system_status_sections as $section ) {
			$section_title   = $section['title'];
			$section_tooltip = $section['tooltip'];
			$debug_data      = $section['data'];
			
			include( \WC_Paytrace::plugin_path() . '/classes/admin/views/system-status.php' );
		}
	}
	
	/**
	 * Return the currency codes that we have set merchant accounts for
	 *
	 * @param $accounts
	 *
	 * @return array
	 */
	public function get_accounts_for_currencies( $accounts ) {
		$currencies = array();
		foreach ( $accounts as $data ) {
			if ( '' == $data['account_id'] ) {
				continue;
			}
			$currencies[] = $data['account_currency'];
		}
		
		return $currencies;
	}
}
