<?php

namespace WcPaytrace\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Admin class to handle any additions for the plugin on the WC Admin
 *
 * @since  2.5.0
 * @author VanboDevelops
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Admin {
	
	/**
	 * @var Admin_Notices
	 */
	public $notices;
	/**
	 * @var Privacy_Policy
	 */
	public $privacy;
	/**
	 * @var Capture
	 */
	public $capture;
	
	public function __construct() {
		$this->load_admin_notices();
		$this->load_capture();
		$this->load_privacy_policy();
		$this->load_system_status();
	}
	
	/**
	 * Loads the admin notices
	 *
	 * @since 2.5.0
	 */
	public function load_admin_notices() {
		// Load admin notices
		$this->notices = new Admin_Notices();
		$this->notices->hooks();
	}
	
	/**
	 * Loads the admin notices
	 *
	 * @since 2.5.0
	 */
	public function load_capture() {
		$this->capture = new Capture();
		$this->capture->hooks();
	}
	
	/**
	 * Loads the Admin Capture procedure setup
	 *
	 * @since 2.5.0
	 */
	public function load_privacy_policy() {
		if ( ! class_exists( 'WC_Abstract_Privacy' ) ) {
			return;
		}
		
		$this->privacy = new Privacy_Policy();
	}
	
	/**
	 * Loads the status page
	 *
	 * @since 2.5.0
	 */
	public function load_system_status() {
		$status = new System_Status( 'paytrace' );
		$status->hooks();
	}
}