/* global wc_paytrace_admin_params */
(function ($) {

	var wcPaytraceOrderCapture = {
		init: function () {
			$('#woocommerce-order-items')
				.on('click', 'button.wc-paytrace-capture-payment-init', this.initOrderCapture)
				.on('click', 'button.wc-paytrace-capture-cancel', this.cancelOrderCapture)
				.on('click', 'button.wc-paytrace-capture-payment', this.processCapture);
		},

		initOrderCapture: function () {
			$('.wc-paytrace-capture-payment-wrapper').slideDown();
			$('.wc-paytrace-capture-amount-wrapper').slideDown();
			$('.wc-paytrace-capture-cancel').slideDown();
			$('button.wc-paytrace-capture-payment-init').hide();
		},

		cancelOrderCapture: function () {
			$('.wc-paytrace-capture-payment-wrapper').hide();
			$('.wc-paytrace-capture-amount-wrapper').hide();
			$('.wc-paytrace-capture-cancel').hide();
			$('button.wc-paytrace-capture-payment-init').slideDown();
		},

		processCapture: function () {
			var orderItems = $('#woocommerce-order-items');
			orderItems.block();

			if (!window.confirm(wc_paytrace_admin_params.i18n_capture_payment)) {
				orderItems.unblock();
				return false;
			}

			var captureAmount = $('.wc-paytrace-capture-amount-wrapper input.wc-paytrace-capture-amount').val();

			if ('' == captureAmount) {
				orderItems.unblock();
				return false;
			}

			var data = {
				action        : 'wc_paytrace_capture_payment',
				order_id      : woocommerce_admin_meta_boxes.post_id,
				capture_amount: captureAmount,
				security      : wc_paytrace_admin_params.capture_payment,
			};

			$.post(wc_paytrace_admin_params.ajax_url, data, function (response) {
				if (true === response.success) {
					// Redirect to same page for show the refunded status
					window.location.href = window.location.href;
				} else {
					window.alert(response.data.error);
					orderItems.unblock();
				}
			});

		},
	};

	var wcPaytraceSettings = {
		formatFieldName: function (name) {
			return 'woocommerce_paytrace_' + name;
		},

		init: function () {
			$('.woocommerce_page_wc-settings').on('change', '#' + wcPaytraceSettings.formatFieldName('integration'), this.loadIntegrationSettings);
			this.initIntegrationChange();
			this.initSettingsChanges();
		},

		initIntegrationChange: function () {
			$('.woocommerce_page_wc-settings #' + wcPaytraceSettings.formatFieldName('integration')).change();
		},

		initSettingsChanges: function () {
			$('#' + wcPaytraceSettings.formatFieldName('separated_forms')).on('change keyup', this.showHideFormSettings).change();
			$('#' + wcPaytraceSettings.formatFieldName('save_customers')).on('change', this.showHideSaveCustomersSettings).change();
			$('#' + wcPaytraceSettings.formatFieldName('support_check')).on('change', this.showHideCheckSettings).change();
			$('#' + wcPaytraceSettings.formatFieldName('json_security_type'))
				.on('change', this.showHideEncryptionSettings)
				.on('change', this.showHideProtectSettings)
				.change();

			$('#' + wcPaytraceSettings.formatFieldName('password')).on('change keyup', this.verifyPassword).change();
		},

		verifyPassword: function (e) {
			var el = $(e.target);
			var password = el.val();

			if (password.indexOf('~') > -1) {
				wcPaytraceSettings.errorNotice(wc_paytrace_admin_params.i18n_password_incorrect, el);
			} else {
				wcPaytraceSettings.resetErrors();
			}
		},

		triggerIntegrationSpecificSettingsChange: function (type) {
			$('#' + wcPaytraceSettings.formatFieldName(type + '_save_customers')).change();
			$('#' + wcPaytraceSettings.formatFieldName(type + '_support_check')).change();
			if ('json' == type) {
				$('#woocommerce_paytrace_json_use_encryption_js').change();
			}

		},

		showHideCheckSettings: function (e) {
			var el = $(e.target);
			var integration = $('#' + wcPaytraceSettings.formatFieldName('integration')).val();
			var showHideEl = $('.show_if_' + integration + '_support_check');
			var showHideBlock = showHideEl.closest('tr');

			if (el.is(':checked')) {
				showHideBlock.slideDown();
				showHideEl.slideDown();
			} else {
				showHideBlock.hide();
				showHideEl.hide();
			}
		},

		showHideSaveCustomersSettings: function (e) {
			var el = $(e.target);
			var integration = $('#' + wcPaytraceSettings.formatFieldName('integration')).val();
			var showHideEl = $('.show_if_' + integration + '_save_customers');
			var showHideBlock = showHideEl.closest('tr');

			if (el.is(':checked')) {
				showHideBlock.slideDown();
				showHideEl.slideDown();
			} else {
				showHideBlock.hide();
				showHideEl.hide();
			}
		},

		showHideEncryptionSettings: function (e) {
			var el = $(e.target);
			var integration = $('#' + wcPaytraceSettings.formatFieldName('integration')).val();
			var showHideEl = $('.show_if_' + integration + '_use_encryption_js');
			var showHideBlock = showHideEl.closest('tr');

			if ('encryption' === el.val()) {
				showHideBlock.slideDown();
				showHideEl.slideDown();
			} else {
				showHideBlock.hide();
				showHideEl.hide();
			}
		},

		showHideProtectSettings: function (e) {
			var el = $(e.target);
			var integration = $('#' + wcPaytraceSettings.formatFieldName('integration')).val();
			var showHideEl = $('.show_if_' + integration + '_use_protect_js');
			var showHideBlock = showHideEl.closest('tr');

			if ('protect' === el.val()) {
				showHideBlock.slideDown();
				showHideEl.slideDown();
			} else {
				showHideBlock.hide();
				showHideEl.hide();
			}
		},

		showHideFormSettings: function (e) {
			var el = $(e.target);
			var separateEl = $('.show_if_separated_forms_separate');
			var separateBlock = separateEl.closest('tr');

			var togetherEl = $('.show_if_separated_forms_together');
			var togetherBlock = togetherEl.closest('tr');

			if (el.val() === 'separate') {
				separateBlock.slideDown();
				separateEl.slideDown();
				togetherBlock.hide();
				togetherEl.hide();
			} else {
				separateBlock.hide();
				separateEl.hide();
				togetherBlock.slideDown();
				togetherEl.slideDown();
			}
		},

		loadIntegrationSettings: function (e) {

			var loadedPage = $('#' + wcPaytraceSettings.formatFieldName('general_settings_start'));

			if ('undefined' === typeof loadedPage) {
				return;
			}

			var integrationEl = $(e.target);
			var integration = integrationEl.val();
			var initial_type = integrationEl.data('initial-type');
			var hideElements = [];
			var showElements = [];
			var errorMessageEl = $('.paytrace_warning');
			errorMessageEl.hide();

			if (integration != initial_type) {
				hideElements = $('.integration_' + initial_type);
				hideElements.hide();
				hideElements.closest('tr').hide();
				wcPaytraceSettings.errorNotice(wc_paytrace_admin_params.i18n_integration_changed, integrationEl.parent());
			} else {
				showElements = $('.integration_' + initial_type);
				showElements.slideDown();
				showElements.closest('tr').slideDown();
				wcPaytraceSettings.resetErrors(integrationEl.parent());
			}

			// Load the settings changes
			wcPaytraceSettings.triggerIntegrationSpecificSettingsChange(integration);
		},

		/**
		 * Displays the errors
		 * @param error
		 * @param el
		 */
		errorNotice: function (error, el) {
			var message = error;

			wcPaytraceSettings.resetErrors(el);

			var messageHtml = wc_paytrace_admin_params.error_wrap.toString().replace('%%message%%', message);

			$(el).after(messageHtml);

		},

		/**
		 * Resets displayed errors
		 */
		resetErrors: function (el) {
			el = el || false;

			if (el) {
				el.parent().find('.wc-paytrace-error').remove();
			} else {
				$('.wc-paytrace-error').remove();
			}
		},
	};

	wcPaytraceSettings.init();
	wcPaytraceOrderCapture.init();

})(jQuery);