<?php
namespace com\cminds\registration\controller;

use com\cminds\registration\App;
use com\cminds\registration\model\Settings;
use com\cminds\registration\model\User;
use com\cminds\registration\model\Labels;
use com\cminds\registration\lib\Email;

class UserController extends Controller {
	
	const ACTION_EDIT = 'cmreg_profile_edit';
	
	static $actions = array(
		'delete_user' => array('args' => 1),
		'user_new_form' => array('method' => 'cmreg_insert_upload_form'),	
		'edit_user_profile' => array('method' => 'cmreg_insert_upload_form'),
		'show_user_profile' => array('method' => 'cmreg_insert_upload_form'),		
		'admin_enqueue_scripts' => array('method' => 'cmreg_print_media_scripts'),
		'edit_user_created_user' => array('method' => 'cmreg_save_user_profile', 'args' => 1),
		'edit_user_profile_update' => array('method' => 'cmreg_save_user_profile', 'args' => 1),
		'personal_options_update' => array('method' => 'cmreg_save_user_profile', 'args' => 1),
	);

	static $filters = array(
		'get_avatar' => array('method' => 'cmreg_avatar_override', 'args' => 6),
	);
	
	static $ajax = array(
		'cmreg_change_password',
		'cmreg_reset_password',
	);

	static function cmreg_insert_upload_form() {
		if(Settings::getOption(Settings::OPTION_PROFILE_PICTURE_ENABLE)) {
			$user_id = isset( $_GET[ 'user_id' ] ) ? absint( $_GET[ 'user_id' ] ) : 0;
			if ( $user_id == 0 && defined( 'IS_PROFILE_PAGE' ) && IS_PROFILE_PAGE == true ) {
				$current_user = wp_get_current_user();
				$user_id = $current_user->ID;
			}
			$user_profile_pic = get_user_meta($user_id, 'profilepicture', true);
			?>
			<table class="form-table cmreg-profile-upload-options">
				<tr>
					<th>
						<label for="image">Profile Picture</label>
					</th>
					<td>
						<input type="hidden" class="button" name="cmreg_profile_image_id" id="cmreg_profile_image_id" value="<?php echo !empty($user_profile_pic) ? esc_url($user_profile_pic) : ''; ?>" />
						<img id="cmreg-img" src="<?php echo !empty($user_profile_pic) ? esc_url($user_profile_pic) : App::url('asset/img/placeholder.png'); ?>" style="max-width: 100px; max-height: 100px;" />
						<br>
						<input type="button" data-id="cmreg_profile_image_id" data-src="cmreg-img" class="button cmreg-image" name="cmreg_image" id="cmreg-image" value="Upload Image" />
						<input type="button" data-id="cmreg_profile_image_id" data-src="cmreg-img" data-placeholdersrc="<?php echo App::url('asset/img/placeholder.png'); ?>" class="button cmreg-remove-image" name="cmreg_remove_image" id="cmreg-remove-image" value="Remove Image" />
					</td>
				</tr>
			</table>
			<style>
			.user-profile-picture { display:none !important; }
			</style>
			<?php
		}
	}
	
	static function cmreg_print_media_scripts() {
		if(Settings::getOption(Settings::OPTION_PROFILE_PICTURE_ENABLE)) {
			wp_enqueue_media();
			wp_enqueue_script('cmreg-uploader', App::url('asset/js/uploaders.js'), array('jquery'), false, true);
		}
	}

	static function cmreg_save_user_profile($user_id) {
		if(Settings::getOption(Settings::OPTION_PROFILE_PICTURE_ENABLE)) {
			if( current_user_can('edit_users') ){
				$user_profile_pic = empty($_POST['cmreg_profile_image_id']) ? '' : esc_url($_POST['cmreg_profile_image_id']);
				update_user_meta($user_id, 'profilepicture', $user_profile_pic);
			}
		}
	}

	static function cmreg_avatar_override($avatar, $id_or_email, $size, $default, $alt, $args = array()) {
		if(!Settings::getOption(Settings::OPTION_PROFILE_PICTURE_ENABLE)) {
			return $avatar;
		}
		global $pagenow;
		if('options-discussion.php' == $pagenow) {
			return $avatar;
		}
		if(is_numeric($id_or_email)) {
			$user = get_user_by('id', (int)$id_or_email);
		} elseif(is_object($id_or_email))  {
			$comment = $id_or_email;
			if(empty($comment->user_id)) {
				$user = get_user_by('id', $comment->user_id);
			} else {
				$user = get_user_by('email', $comment->comment_author_email);
			}
			if(!$user) {
				return $avatar;
			}
		} elseif(is_string($id_or_email)) {
			$user = get_user_by('email', $id_or_email);
		} else {
			return $avatar;
		}
		if(!$user) {
			return $avatar;
		}
		$user_id = $user->ID;

		$classes = array('avatar', sprintf( 'avatar-%s', esc_attr( $size ) ), 'photo');	
		if(isset($args['class'])) {
			if(is_array($args['class'])) {
				$classes = array_merge($classes, $args['class']);
			} else {
				$args['class'] = explode(' ', $args['class']);
				$classes = array_merge($classes, $args['class']);
			}
		}

		$classes = (array)apply_filters( 'dpp_avatar_classes', $classes );

		$custom_avatar = self::cmreg_profile_img( $user_id, array( 
			'size' => array( $size, $size ), 
			'attr' => array( 'alt' => $alt, 'class' => implode( ' ', $classes ) ), 
			'echo' => false )
		 );

		if(!$custom_avatar) {
			return $avatar;
		}

		return $custom_avatar;
	}

	static function cmreg_profile_img( $user_id, $args = array() ) {
		$defaults = array(
			'size' => 'thumbnail',
			'attr' => '',
			'echo' => true
		);
		$args = wp_parse_args($args, $defaults);
		extract($args);
		$user_profile = '';
		$user_profile_pic = get_user_meta($user_id, 'profilepicture', true);
		if ($user_profile_pic) {
			$user_profile = '<img alt="" src="'.esc_url($user_profile_pic).'" class="avatar avatar-'.$size[0].' photo" height="'.$size[0].'" width="'.$size[0].'" />';
		}
		if($echo) {
			echo $user_profile;
		} else {
			return $user_profile;
		}
	}

	static function cmreg_change_password() {
	
		$response = array('success' => 0, 'msg' => 'An error occurred. Please try again.');
	
		$nonce = filter_input(INPUT_POST, 'nonce');
		if ($nonce AND wp_verify_nonce($nonce, static::ACTION_EDIT)) {
			
			$pass = trim(filter_input(INPUT_POST, 'cmregef_password'));
			$pass2 = trim(filter_input(INPUT_POST, 'cmregef_password_repeat'));
				
			try {
				
				if (strlen($pass) == 0) {
					throw new \Exception(Labels::getLocalized('change_password_error_empty_pass'));
				}
				if ($pass !== $pass2) {
					throw new \Exception(Labels::getLocalized('change_password_error_pass_does_not_match'));
				}
	
				User::setPassword(get_current_user_id(), $pass);
				update_user_meta(get_current_user_id(), 'userpw', base64_encode($pass));
				delete_user_meta(get_current_user_id(), 'salt');
	
				$response['success'] = 1;
				$response['msg'] = Labels::getLocalized('change_password_success');
	
			} catch (\Exception $e) {
				$response['msg'] = $e->getMessage();
			}
				
		}
	
		header('content-type: application/json');
		echo json_encode($response);
		exit;
	}

	static function cmreg_reset_password() {
		
		$url = Settings::getOption(Settings::OPTION_WP_LOSTPASSWORD_PAGE_REDIRECTION_URL);

		$response = array('success' => 0, 'msg' => 'An error occurred. Please try again.');
	
		$nonce = filter_input(INPUT_POST, 'nonce');
		if ($nonce AND wp_verify_nonce($nonce, static::ACTION_EDIT)) {
			
			$pass = trim(filter_input(INPUT_POST, 'cmregreset_password'));
			$rp_key = trim(filter_input(INPUT_POST, 'rp_key'));
			
			if($url != '') {
				$user_login = rawurldecode(base64_decode(trim(filter_input(INPUT_POST, 'user_login'))));
			} else {
				$user_login = trim(filter_input(INPUT_POST, 'user_login'));
			}
				
			try {
				
				if (strlen($pass) == 0) {
					throw new \Exception(Labels::getLocalized('reset_password_error_empty_pass'));
				}
				
				if(is_email($user_login)) {
					$user = get_user_by( 'email', $user_login );
					if(!$user) {
						$user = get_user_by( 'login', $user_login );
					}
				} else {
					$user = get_user_by( 'login', $user_login );
				}
				
				if(isset($user->ID) && !empty($user->ID))
				{
					User::resetPassword($user->ID, $pass);
					delete_user_meta($user->ID, 'salt');
					$response['success'] = 1;
					$response['msg'] = Labels::getLocalized('reset_password_success');
				}
				else
				{
					$response['success'] = 0;
					$response['msg'] = 'An error occurred. Please try again.';
				}
			} catch (\Exception $e) {
				$response['msg'] = $e->getMessage();
			}
				
		}
	
		header('content-type: application/json');
		echo json_encode($response);
		exit;
	
	}

	static function delete_user($userId) {
		if (Settings::getOption(Settings::OPTION_ACCOUNT_DELETED_USER_EMAIL_ENABLE) AND $user = get_userdata($userId)) {
			$subject = Settings::getOption(Settings::OPTION_ACCOUNT_DELETED_USER_EMAIL_SUBJECT);
			$body = wpautop(Settings::getOption(Settings::OPTION_ACCOUNT_DELETED_USER_EMAIL_BODY));
			$vars = array_merge(Email::getBlogVars(), Email::getUserVars($userId));
			Email::send($user->user_email, $subject, $body, $vars);
			User::cmreg_delete_user($userId);
		}
	}
	
}